package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.model.param.PointParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.util.PointReportUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lowi
 * @date 2022/2/22 10:14
 */
@Service
@Slf4j
@AllArgsConstructor
public class SignTaskActionStrategy extends AbstractUserTaskStrategy {

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final UserTaskInfoService userTaskInfoService;

    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Boolean currSign = redisHashMapAdapter.get(builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()),
                                                   completeTaskParam.getTaskId().toString(), Boolean.class
        );

        if (Objects.equals(currSign, Boolean.TRUE)) {
            return Message.build(Boolean.FALSE).setMessage("用户当天已签到");
        }
        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        //获取用户应该获取多少g粮食
        Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
            userAccountInfo.getTotalFoods(),
            TaskActionEnum.SIGN
        );

        Message message = sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "签到奖励");

        if (!message.isSuccess()) {
            return message;
        }

        //增加签到次数
        redisHashMapAdapter.increment(
            builderDailyTaskKey(completeTaskParam.getUserId()),
            completeTaskParam.getTaskId().toString(),
            1
        );
        redisHashMapAdapter.expire(builderDailyTaskKey(completeTaskParam.getUserId()), DateUtils.getCurSeconds());

        //把当天任务置为完成
        redisHashMapAdapter.put(
            builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()),
            completeTaskParam.getTaskId().toString(),
            Boolean.TRUE
        );

        extTaskReward(completeTaskParam.getUserId());

        Message build = Message.build();

        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("签到成功");
        completeTaskDTO.setAwardNum(userAwardGrainNum);

        hasAd(completeTaskParam, userAccountInfo, completeTaskDTO);

        // 增加签到完成的数据埋点
        PointReportUtils.report(PointParam.build(completeTaskParam)
                                          .project("daily")
                                          .event(3034)
                                          .eventValue("103")
                                          .userId(completeTaskParam.getUserId()));

        // V1.2.0 去除签到后返回额外任务
        //        AppVersionParam appVersionParam = new AppVersionParam();
        //        appVersionParam.merge(completeTaskParam);
        //        Boolean status = appChnlVersionIntegrationService.getArraignmentStatus(appVersionParam);

        //如果不为提审状态,返回额外签到视频
        //        if (Objects.equals(Boolean.FALSE, status)) {
        //
        //            ExtendTaskDTO extendTaskDTO = new ExtendTaskDTO();
        //            extendTaskDTO.setAction(TaskActionEnum.EXT_VIDEO_REWARD.name());
        //            extendTaskDTO.setAwardGrainNum(5);
        //            completeTaskDTO.setExtendTask(extendTaskDTO);
        //        }

        build.addParam("resultDTO", completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.SIGN.name();
    }

}
