package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author lowi
 * @date 2022/2/22 10:14
 */
@Service
@Slf4j
@AllArgsConstructor
public class WelfareVideoTaskActionStrategy extends AbstractUserTaskStrategy {

    private final RedisHashMapAdapter redisHashMapAdapter;

    private final UserTaskInfoService userTaskInfoService;

    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {

        Long taskId = completeTaskParam.getTaskId();

        Integer videoNum = userTaskInfoService.getUserDailyTaskFinishNum(completeTaskParam.getUserId(), taskId);

        TaskListItemDTO taskInfo = getTaskInfo(TaskActionEnum.WELFARE_VIDEO.name());

        if (videoNum >= taskInfo.getMaxTimes()) {
            return Message.build(Boolean.FALSE).setMessage("此任务已完成,请勿重复点击");
        }

        return Message.build(Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {

        UserAccountDTO userAccountInfo = userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        //获取用户应该获取多少g粮食
        Integer userAwardGrainNum = taskConfigFacadeService.getAwardConfig(
            userAccountInfo.getTotalFoods(),
            TaskActionEnum.WELFARE_VIDEO
        );

        Message message = sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "观看福利视频奖励");

        if (!message.isSuccess()) {
            return message;
        }

        //增加观看视频次数
        redisHashMapAdapter.increment(
            builderDailyTaskKey(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), 1);
        redisHashMapAdapter.expire(builderDailyTaskKey(completeTaskParam.getUserId()), DateUtils.getCurSeconds());

        TaskListItemDTO taskInfo = getTaskInfo(TaskActionEnum.WELFARE_VIDEO.name());

        Integer currNum = redisHashMapAdapter.get(builderDailyTaskKey(completeTaskParam.getUserId()),
                                                  completeTaskParam.getTaskId().toString(), Integer.class
        );

        if (Objects.equals(taskInfo.getMaxTimes(), currNum)) {
            //把当天任务置为完成
            redisHashMapAdapter.put(builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()),
                                    completeTaskParam.getTaskId().toString(), Boolean.TRUE
            );
        }

        extTaskReward(completeTaskParam.getUserId());

        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("领取成功");
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        hasAd(completeTaskParam, userAccountInfo, completeTaskDTO);

        return Message.build().addParam("resultDTO", completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.WELFARE_VIDEO.name();
    }

}
