/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.cache;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.SystemClock;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.collect.Maps;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskCacheHolder {
    private static final Logger log = LoggerFactory.getLogger(TaskCacheHolder.class);
    private RedisSetAdapter redisSetAdapter;
    private RedisStringAdapter redisStringAdapter;
    private RedisHashMapAdapter redisHashMapAdapter;
    private TaskProperties taskProperties;

    public void addGuideAwardRecord(Long userId) {
        this.redisSetAdapter.add(this.buildKey(userId), new Object[]{userId});
    }

    public boolean hasGuideAwardRecord(Long userId) {
        return this.redisSetAdapter.exists(this.buildKey(userId), (Object)userId);
    }

    private KeyGenerator buildKey(Long userId) {
        return RedisCacheConstant.USER_GUIDE_AWARD_CACHE.copy().appendKey((Object)(userId % 100L));
    }

    private KeyGenerator buildBubbleTaskKey(Long userId) {
        return RedisCacheConstant.USER_BUBBLE_TASK_CACHE.copy().appendKey((Object)((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date())).appendKey((Object)userId);
    }

    public Integer getTodayBubbleTaskNum(Long userId) {
        return this.redisStringAdapter.getInt(this.buildBubbleTaskKey(userId));
    }

    public void addUserBubbleTask(Long userId) {
        KeyGenerator key = this.buildBubbleTaskKey(userId);
        this.redisStringAdapter.increment(key);
        this.redisStringAdapter.expireWithDisrupt(key, (long)DateUtils.getCurSeconds());
    }

    public Map<String, Integer> getTodayBubbleV3(Long userId) {
        KeyGenerator key = this.buildBubbleV3Key(userId);
        return this.redisHashMapAdapter.entries(key, Integer.class);
    }

    public void addTodayBubbleV3Times(Long userId, TaskActionEnum action) {
        KeyGenerator key = this.buildBubbleV3Key(userId);
        this.redisHashMapAdapter.increment(key, action.name(), 1);
        this.redisHashMapAdapter.expireWithDisrupt(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator buildBubbleV3Key(Long userId) {
        return RedisCacheConstant.BUBBLE_TASK_V3_CACHE.copy().appendKey((Object)DatePattern.PURE_DATE_FORMAT.format(SystemClock.now())).appendKey((Object)userId);
    }

    public Map<String, UserTaskItemBO> initTaskCache(Long userId) {
        HashMap cacheData = Maps.newHashMap();
        Map<String, TaskProperties.TaskConfigV3> taskConfigV3Map = this.taskProperties.getTaskConfigV3Map();
        for (Map.Entry<String, TaskProperties.TaskConfigV3> configV3Entry : taskConfigV3Map.entrySet()) {
            TaskProperties.TaskConfigV3 value = configV3Entry.getValue();
            UserTaskItemBO item = new UserTaskItemBO();
            item.setTaskId(Long.valueOf(-1L));
            item.setCurrent(Integer.valueOf(0));
            item.setManual(value.getManual());
            item.setMax(value.getMax());
            item.setOrder(value.getOrder());
            item.setTaskAction(configV3Entry.getKey());
            item.setFinish(Boolean.valueOf(false));
            cacheData.put(configV3Entry.getKey(), item);
        }
        KeyGenerator key = this.buildTodayTaskCacheKey(userId);
        this.redisHashMapAdapter.putAll(key, (Map)cacheData);
        this.redisHashMapAdapter.expireWithDisrupt(key, (long)DateUtils.getCurSeconds());
        return cacheData;
    }

    public Map<String, UserTaskItemBO> fetchUserTask(Long userId) {
        KeyGenerator key = this.buildTodayTaskCacheKey(userId);
        return this.redisHashMapAdapter.entries(key, UserTaskItemBO.class);
    }

    public void addTaskTimes(Long userId, TaskActionEnum action) {
        KeyGenerator key;
        UserTaskItemBO cacheItem;
        if (log.isDebugEnabled()) {
            log.debug("\u7528\u6237[{}]\u589e\u52a0\u4efb\u52a1[{}]\u6b21\u6570", (Object)userId, (Object)action);
        }
        if (null == (cacheItem = (UserTaskItemBO)this.redisHashMapAdapter.get(key = this.buildTodayTaskCacheKey(userId), action.name(), UserTaskItemBO.class)) && null == (cacheItem = this.initTaskCache(userId).get(action.name()))) {
            log.error("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4efb\u52a1\uff0c\u7528\u6237ID\uff1a{},\u4efb\u52a1\uff1a{}", (Object)userId, (Object)action);
            return;
        }
        if (log.isDebugEnabled() && cacheItem.getCurrent() >= cacheItem.getMax()) {
            log.debug("\u7528\u6237[{}]\u5b8c\u6210\u4efb\u52a1[{}]\u6b21\u6570\u8fbe\u6807", (Object)userId, (Object)action);
        }
        if (!cacheItem.getFinish().booleanValue() && cacheItem.getCurrent() < cacheItem.getMax()) {
            cacheItem.setCurrent(Integer.valueOf(cacheItem.getCurrent() + 1));
            if (!cacheItem.getManual().booleanValue() && Objects.equals(cacheItem.getCurrent(), cacheItem.getMax())) {
                cacheItem.setFinish(Boolean.valueOf(true));
            }
            this.redisHashMapAdapter.put(key, action.name(), (Object)cacheItem);
        }
    }

    public void setTaskFinish(Long userId, TaskActionEnum action) {
        KeyGenerator key = this.buildTodayTaskCacheKey(userId);
        UserTaskItemBO cacheItem = (UserTaskItemBO)this.redisHashMapAdapter.get(key, action.name(), UserTaskItemBO.class);
        if (!cacheItem.getFinish().booleanValue()) {
            cacheItem.setFinish(Boolean.valueOf(true));
            this.redisHashMapAdapter.put(key, action.name(), (Object)cacheItem);
        }
    }

    private KeyGenerator buildTodayTaskCacheKey(Long userId) {
        return RedisCacheConstant.TODAY_USER_TASK_CACHE.copy().appendKey((Object)DatePattern.PURE_DATE_FORMAT.format(SystemClock.now())).appendKey((Object)userId);
    }

    public TaskCacheHolder(RedisSetAdapter redisSetAdapter, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, TaskProperties taskProperties) {
        this.redisSetAdapter = redisSetAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.taskProperties = taskProperties;
    }
}

