/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.evnet;

import com.bxm.component.bus.annotations.EventBusSubscriber;
import com.bxm.component.bus.guava.AllowConcurrentEvents;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.event.JoinLotteryEvent;
import com.bxm.dailyegg.common.event.PickEggEvent;
import com.bxm.dailyegg.common.event.PickGrainEvent;
import com.bxm.dailyegg.common.event.SpeedUpEvent;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import org.springframework.stereotype.Component;

@Component
public class TaskEventSubscriber {
    private TaskCacheHolder taskCacheHolder;

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void addJoinTimes(JoinLotteryEvent event) {
        this.taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.JOIN_LOTTERY_V3);
    }

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void pickEgg(PickEggEvent event) {
        this.taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.PICK_EGG_V3);
    }

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void pickGrain(PickGrainEvent event) {
        this.taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.PICK_GRAIN_V3);
    }

    @EventBusSubscriber
    @AllowConcurrentEvents
    public void speedUp(SpeedUpEvent event) {
        this.taskCacheHolder.addTaskTimes(event.getUserId(), TaskActionEnum.SPEED_UP_V3);
    }

    public TaskEventSubscriber(TaskCacheHolder taskCacheHolder) {
        this.taskCacheHolder = taskCacheHolder;
    }
}

