/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.facade.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.task.service.TaskV3Service;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.facade.UserAccountFacadeService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskConfigFacadeServiceImpl
implements TaskConfigFacadeService {
    private static final Logger log = LoggerFactory.getLogger(TaskConfigFacadeServiceImpl.class);
    private UserAccountFacadeService userAccountFacadeService;
    private TaskProperties taskProperties;

    public Integer getAwardConfig(Integer totalFoods, TaskActionEnum action) {
        Map<String, List<TaskProperties.TaskAwardConfig>> configMap = this.taskProperties.getConfigMap();
        List<TaskProperties.TaskAwardConfig> taskAwardConfigs = configMap.get(action.name());
        if (null == taskAwardConfigs) {
            log.error("\u6ca1\u6709\u914d\u7f6e[{}]\u5bf9\u5e94\u7684\u5956\u52b1", (Object)action);
            return 0;
        }
        Optional<TaskProperties.TaskAwardConfig> matchConfig = taskAwardConfigs.stream().filter(config -> {
            if (null != totalFoods && totalFoods >= 0) {
                return config.getRange().match(totalFoods);
            }
            return false;
        }).findFirst();
        if (matchConfig.isPresent()) {
            return matchConfig.get().getAwardNum();
        }
        log.error("[{}]\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u914d\u7f6e,\u7528\u6237\u7cae\u98df\u603b\u6570\u4e3a\uff1a{}", (Object)action, (Object)totalFoods);
        return 0;
    }

    public Integer getAwardConfigWithUserId(Long userId, TaskActionEnum taskAction) {
        UserAccountDTO userAccountDTO = this.userAccountFacadeService.loadUserAccount(userId);
        return this.getAwardConfig(userAccountDTO.getTotalFoods(), taskAction);
    }

    public Integer getAllTaskAwardNum(Long userId) {
        TaskV3Service taskV3Service = (TaskV3Service)SpringContextHolder.getBean(TaskV3Service.class);
        BaseUserParam param = new BaseUserParam();
        param.setUserId(userId);
        List<TaskListItemV2DTO> taskList = taskV3Service.fetchList(param);
        int total = 0;
        for (TaskListItemV2DTO taskItem : taskList) {
            if (taskItem.getManual().booleanValue()) {
                total += taskItem.getAwardGrainNum().intValue();
                continue;
            }
            total += taskItem.getAwardGrainNum() * taskItem.getMaxTimes();
        }
        return total;
    }

    public TaskConfigFacadeServiceImpl(UserAccountFacadeService userAccountFacadeService, TaskProperties taskProperties) {
        this.userAccountFacadeService = userAccountFacadeService;
        this.taskProperties = taskProperties;
    }
}

