/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.handler;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.handler.UserBubbleTaskHandlerService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserBubbleTaskContentBO;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserTaskHandlerManage {
    @Resource
    private TaskProperties taskProperties;
    List<UserDailyTaskHandlerService> userDailyTaskHandlerServices;
    List<UserBubbleTaskHandlerService> userBubbleTaskHandlerServices;

    @Autowired
    public UserTaskHandlerManage(List<UserDailyTaskHandlerService> userDailyTaskHandlerServices, List<UserBubbleTaskHandlerService> userBubbleTaskHandlerServices) {
        this.userDailyTaskHandlerServices = userDailyTaskHandlerServices;
        this.userBubbleTaskHandlerServices = userBubbleTaskHandlerServices;
    }

    public void dailyTaskHandler(UserTaskContentBO userTaskContentBO) {
        if (CollectionUtil.isEmpty((Collection)userTaskContentBO.getListItemDTOS())) {
            return;
        }
        if (CollectionUtil.isNotEmpty(this.userDailyTaskHandlerServices)) {
            for (UserDailyTaskHandlerService taskHandlerService : this.userDailyTaskHandlerServices) {
                taskHandlerService.handler(userTaskContentBO);
            }
        }
    }

    public void bubbleTaskHandler(UserBubbleTaskContentBO userBubbleTaskContentBO) {
        if (CollectionUtil.isEmpty((Collection)userBubbleTaskContentBO.getListItemDTOS())) {
            return;
        }
        if (CollectionUtil.isNotEmpty(this.userBubbleTaskHandlerServices)) {
            for (UserBubbleTaskHandlerService taskHandlerService : this.userBubbleTaskHandlerServices) {
                taskHandlerService.handler(userBubbleTaskContentBO);
            }
        }
    }
}

