/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.handler.bubbletask;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserBubbleTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserBubbleTaskContentBO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BubbleTaskVideoHandler
implements UserBubbleTaskHandlerService {
    private static final Logger log = LoggerFactory.getLogger(BubbleTaskVideoHandler.class);
    private final UserTaskInfoService userTaskInfoService;
    private final TaskConfigFacadeService taskConfigFacadeService;

    @Override
    public void handler(UserBubbleTaskContentBO userBubbleTaskContentBO) {
        List bubbleTaskItemDTOS = userBubbleTaskContentBO.getListItemDTOS();
        BaseUserParam param = userBubbleTaskContentBO.getOriginParam();
        bubbleTaskItemDTOS.removeIf(bubbleTaskItemDTO -> {
            if (this.userTaskInfoService.bubbleTaskFinish(param.getUserId(), bubbleTaskItemDTO.getTaskId()).booleanValue()) {
                return Boolean.TRUE;
            }
            Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userBubbleTaskContentBO.getTotalFoods(), TaskActionEnum.valueOf((String)bubbleTaskItemDTO.getAction()));
            bubbleTaskItemDTO.setAwardGrainNum(userAwardGrainNum);
            return Boolean.FALSE;
        });
    }

    public BubbleTaskVideoHandler(UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

