/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class DailyTaskOpenAppTwoHandler
implements UserDailyTaskHandlerService {
    private final UserTaskInfoService userTaskInfoService;
    private final TaskConfigFacadeService taskConfigFacadeService;
    private static String SUB_TITLE = "\u4eca\u65e5\u6253\u5f00\u4e24\u6b21APP,\u4e14\u4e24\u6b21\u95f4\u9694\u81f3\u5c1110\u5206\u949f";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();
        List listItemDTOS = userTaskContentBO.getListItemDTOS();
        listItemDTOS.forEach(taskListItemDTO -> {
            if (Objects.equals(taskListItemDTO.getAction(), TaskActionEnum.OPEN_APP_TWO.name())) {
                int currentTimes = this.userTaskInfoService.dailyTaskFinish(originParam.getUserId(), taskListItemDTO.getTaskId()) != false ? 1 : 0;
                taskListItemDTO.setCurrentTimes(Integer.valueOf(currentTimes));
                Integer awardGrainNum = this.taskConfigFacadeService.getAwardConfig(userTaskContentBO.getTotalFoods(), TaskActionEnum.OPEN_APP_TWO);
                taskListItemDTO.setAwardGrainNum(awardGrainNum);
                taskListItemDTO.setSubTitle(String.format(SUB_TITLE, awardGrainNum));
                taskListItemDTO.setTaskStatus(Boolean.valueOf(currentTimes >= taskListItemDTO.getMaxTimes()));
                taskListItemDTO.setLookVideo(Boolean.valueOf(false));
            }
        });
        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

    public DailyTaskOpenAppTwoHandler(UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

