/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.integration.AppChnlVersionIntegrationService;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.foundation.base.facade.param.AppVersionParam;
import com.bxm.newidea.component.param.BasicParam;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class DailyTaskSignHandler
implements UserDailyTaskHandlerService {
    private final UserTaskInfoService userTaskInfoService;
    private final AppChnlVersionIntegrationService appChnlVersionIntegrationService;
    private TaskConfigFacadeService taskConfigFacadeService;
    private static String SUB_TITLE = "\u70b9\u51fb\u7b7e\u5230\u5e76\u89c2\u770b\u6fc0\u52b1\u89c6\u9891,\u5b8c\u6210\u540e\u83b7\u5f97%s\u514b\u7cae\u98df";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();
        List listItemDTOS = userTaskContentBO.getListItemDTOS();
        listItemDTOS.forEach(taskListItemDTO -> {
            if (Objects.equals(taskListItemDTO.getAction(), TaskActionEnum.SIGN.name())) {
                int currentTimes = this.userTaskInfoService.getUserDailyTaskFinishNum(originParam.getUserId(), taskListItemDTO.getTaskId());
                taskListItemDTO.setCurrentTimes(Integer.valueOf(currentTimes));
                Integer awardGrainNum = this.taskConfigFacadeService.getAwardConfig(userTaskContentBO.getTotalFoods(), TaskActionEnum.SIGN);
                taskListItemDTO.setAwardGrainNum(awardGrainNum);
                taskListItemDTO.setSubTitle(String.format(SUB_TITLE, awardGrainNum));
                taskListItemDTO.setTaskStatus(Boolean.valueOf(currentTimes >= taskListItemDTO.getMaxTimes()));
                AppVersionParam appVersionParam = new AppVersionParam();
                appVersionParam.merge((BasicParam)originParam);
                Boolean status = this.appChnlVersionIntegrationService.getArraignmentStatus(appVersionParam);
                if (Objects.equals(Boolean.TRUE, status)) {
                    taskListItemDTO.setLookVideo(Boolean.FALSE);
                }
            }
        });
        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

    public DailyTaskSignHandler(UserTaskInfoService userTaskInfoService, AppChnlVersionIntegrationService appChnlVersionIntegrationService, TaskConfigFacadeService taskConfigFacadeService) {
        this.userTaskInfoService = userTaskInfoService;
        this.appChnlVersionIntegrationService = appChnlVersionIntegrationService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

