/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class DailyTaskVideoHandler
implements UserDailyTaskHandlerService {
    private final UserTaskInfoService userTaskInfoService;
    private final TaskConfigFacadeService taskConfigFacadeService;
    private static String SUB_TITLE = "\u6bcf\u770b\u4e00\u4e2a\u89c6\u9891\u53ef\u83b7\u5f97%s\u514b\u7cae\u98df,\u53ef\u505a10\u6b21,\u7d2f\u8ba1\u53ef\u83b7\u5f97%s\u514b\u7cae\u98df";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();
        List listItemDTOS = userTaskContentBO.getListItemDTOS();
        listItemDTOS.forEach(taskListItemDTO -> {
            if (Objects.equals(taskListItemDTO.getAction(), TaskActionEnum.VIDEO.name())) {
                int currentTimes = this.userTaskInfoService.getUserDailyTaskFinishNum(originParam.getUserId(), taskListItemDTO.getTaskId());
                Integer awardGrainNum = this.taskConfigFacadeService.getAwardConfig(userTaskContentBO.getTotalFoods(), TaskActionEnum.VIDEO);
                taskListItemDTO.setAwardGrainNum(awardGrainNum);
                taskListItemDTO.setCurrentTimes(Integer.valueOf(currentTimes));
                taskListItemDTO.setSubTitle(String.format(SUB_TITLE, awardGrainNum, awardGrainNum * taskListItemDTO.getMaxTimes()));
                taskListItemDTO.setTaskStatus(Boolean.valueOf(currentTimes >= taskListItemDTO.getMaxTimes()));
            }
        });
        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

    public DailyTaskVideoHandler(UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

