/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.handler.daliytask.impl;

import com.bxm.dailyegg.common.constant.TaskCommonConstant;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.handler.UserDailyTaskHandlerService;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class UserGuideHandler
implements UserDailyTaskHandlerService {
    private TaskCacheHolder taskCacheHolder;
    private TaskProperties taskProperties;
    private static String SUB_TITLE = "\u70b9\u51fb\u7b7e\u5230\u5e76\u89c2\u770b\u6fc0\u52b1\u89c6\u9891,\u5b8c\u6210\u540e\u83b7\u5f97%s\u514b\u7cae\u98df";

    @Override
    public void handler(UserTaskContentBO userTaskContentBO) {
        BaseUserParam originParam = userTaskContentBO.getOriginParam();
        if (this.taskCacheHolder.hasGuideAwardRecord(originParam.getUserId())) {
            return;
        }
        List listItemDTOS = userTaskContentBO.getListItemDTOS();
        TaskListItemDTO taskItem = new TaskListItemDTO();
        taskItem.setTaskId(TaskCommonConstant.GUIDE_TASK_ID);
        taskItem.setAction(TaskActionEnum.GUIDE_VIDEO.name());
        taskItem.setMaxTimes(Integer.valueOf(1));
        taskItem.setAwardGrainNum(Integer.valueOf(this.taskProperties.getGuideAwardNum()));
        taskItem.setCurrentTimes(Integer.valueOf(0));
        taskItem.setLookVideo(Boolean.valueOf(false));
        taskItem.setTitle("\u89c2\u770b\u9886\u86cb\u79d8\u7c4d");
        taskItem.setSubTitle("\u89c2\u770b\u9886\u86cb\u79d8\u7c4d,\u83b7\u5f97\u5feb\u901f\u9886\u9e21\u86cb\u7684\u7a8d\u95e8,\u8fd8\u80fd\u83b7\u5f97" + taskItem.getAwardGrainNum() + "\u514b\u7cae\u98df");
        taskItem.setTaskStatus(Boolean.FALSE);
        if (listItemDTOS.size() > 0) {
            listItemDTOS.add(1, taskItem);
        } else {
            listItemDTOS.add(taskItem);
        }
        userTaskContentBO.setListItemDTOS(listItemDTOS);
    }

    public UserGuideHandler(TaskCacheHolder taskCacheHolder, TaskProperties taskProperties) {
        this.taskCacheHolder = taskCacheHolder;
        this.taskProperties = taskProperties;
    }
}

