/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.listener;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class TaskCacheRedisRunner
implements ApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(TaskCacheRedisRunner.class);
    private final RedisStringAdapter redisStringAdapter;

    public void onApplicationEvent(ApplicationEvent event) {
        List oldBubbleTaskList;
        List oldDailyTaskList = (List)this.redisStringAdapter.get(RedisCacheConstant.DAILY_TASK_LIST.copy(), (TypeReference)new TypeReference<List<TaskListItemDTO>>(){});
        if (CollectionUtil.isEmpty((Collection)oldDailyTaskList) || Objects.isNull(((TaskListItemDTO)oldDailyTaskList.get(0)).getV()) || ((TaskListItemDTO)oldDailyTaskList.get(0)).getV() < TaskListItemDTO.CACHE_VERSION) {
            this.redisStringAdapter.remove(RedisCacheConstant.DAILY_TASK_LIST.copy());
            this.loadDailyTask();
        }
        if (CollectionUtil.isEmpty((Collection)(oldBubbleTaskList = (List)this.redisStringAdapter.get(RedisCacheConstant.BUBBLE_TASK_LIST.copy(), (TypeReference)new TypeReference<List<BubbleTaskItemDTO>>(){}))) || Objects.isNull(((BubbleTaskItemDTO)oldBubbleTaskList.get(0)).getV()) || ((BubbleTaskItemDTO)oldBubbleTaskList.get(0)).getV() < BubbleTaskItemDTO.CACHE_VERSION) {
            this.redisStringAdapter.remove(RedisCacheConstant.BUBBLE_TASK_LIST.copy());
            this.loadBubbleTask();
        }
    }

    private void loadDailyTask() {
        ArrayList<TaskListItemDTO> taskListItemDTOS = new ArrayList<TaskListItemDTO>();
        TaskListItemDTO taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("\u7b7e\u5230");
        taskListItemDTO.setMaxTimes(Integer.valueOf(1));
        taskListItemDTO.setTaskId(Long.valueOf(1L));
        taskListItemDTO.setAction(TaskActionEnum.SIGN.name());
        taskListItemDTOS.add(taskListItemDTO);
        taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("\u89c2\u770b\u89c6\u9891");
        taskListItemDTO.setMaxTimes(Integer.valueOf(10));
        taskListItemDTO.setTaskId(Long.valueOf(2L));
        taskListItemDTO.setAction(TaskActionEnum.VIDEO.name());
        taskListItemDTOS.add(taskListItemDTO);
        taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("\u89c2\u770b\u798f\u5229\u89c6\u9891");
        taskListItemDTO.setMaxTimes(Integer.valueOf(10));
        taskListItemDTO.setTaskId(Long.valueOf(3L));
        taskListItemDTO.setAction(TaskActionEnum.WELFARE_VIDEO.name());
        taskListItemDTOS.add(taskListItemDTO);
        taskListItemDTO = new TaskListItemDTO();
        taskListItemDTO.setTitle("\u6253\u5f00\u4e24\u6b21APP");
        taskListItemDTO.setMaxTimes(Integer.valueOf(1));
        taskListItemDTO.setTaskId(Long.valueOf(4L));
        taskListItemDTO.setAction(TaskActionEnum.OPEN_APP_TWO.name());
        taskListItemDTOS.add(taskListItemDTO);
        this.redisStringAdapter.set(RedisCacheConstant.DAILY_TASK_LIST.copy(), taskListItemDTOS);
    }

    private void loadBubbleTask() {
        ArrayList<BubbleTaskItemDTO> bubbleTaskItemDTOS = new ArrayList<BubbleTaskItemDTO>();
        BubbleTaskItemDTO bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(Long.valueOf(1L));
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(Long.valueOf(2L));
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(Long.valueOf(3L));
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(Long.valueOf(4L));
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        bubbleTaskItemDTO = new BubbleTaskItemDTO();
        bubbleTaskItemDTO.setTaskId(Long.valueOf(5L));
        bubbleTaskItemDTO.setAction(TaskActionEnum.BUBBLE_VIDEO.name());
        bubbleTaskItemDTOS.add(bubbleTaskItemDTO);
        this.redisStringAdapter.set(RedisCacheConstant.BUBBLE_TASK_LIST.copy(), bubbleTaskItemDTOS);
    }

    public TaskCacheRedisRunner(RedisStringAdapter redisStringAdapter) {
        this.redisStringAdapter = redisStringAdapter;
    }
}

