/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.service.context;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import java.util.List;
import java.util.Map;

public class UserTaskContext {
    private BaseUserParam param;
    private Map<String, UserTaskItemBO> taskCacheMap;
    private List<TaskListItemV2DTO> finalTaskList;
    private UserAccountDTO userAccount;
    private TaskConfigFacadeService configService;

    public Integer getConfigAwardNum(TaskActionEnum action) {
        return this.configService.getAwardConfig(this.getTotalFoods(), action);
    }

    public Integer getTotalFoods() {
        return this.userAccount.getTotalFoods();
    }

    public Long getUserId() {
        return this.param.getUserId();
    }

    public void addItem(TaskListItemV2DTO item) {
        this.finalTaskList.add(item);
    }

    public UserTaskItemBO getCacheTaskItem(TaskActionEnum action) {
        return this.taskCacheMap.getOrDefault(action.name(), new UserTaskItemBO());
    }

    UserTaskContext(BaseUserParam param, Map<String, UserTaskItemBO> taskCacheMap, List<TaskListItemV2DTO> finalTaskList, UserAccountDTO userAccount, TaskConfigFacadeService configService) {
        this.param = param;
        this.taskCacheMap = taskCacheMap;
        this.finalTaskList = finalTaskList;
        this.userAccount = userAccount;
        this.configService = configService;
    }

    public static UserTaskContextBuilder builder() {
        return new UserTaskContextBuilder();
    }

    public BaseUserParam getParam() {
        return this.param;
    }

    public Map<String, UserTaskItemBO> getTaskCacheMap() {
        return this.taskCacheMap;
    }

    public List<TaskListItemV2DTO> getFinalTaskList() {
        return this.finalTaskList;
    }

    public UserAccountDTO getUserAccount() {
        return this.userAccount;
    }

    public TaskConfigFacadeService getConfigService() {
        return this.configService;
    }

    public void setParam(BaseUserParam param) {
        this.param = param;
    }

    public void setTaskCacheMap(Map<String, UserTaskItemBO> taskCacheMap) {
        this.taskCacheMap = taskCacheMap;
    }

    public void setFinalTaskList(List<TaskListItemV2DTO> finalTaskList) {
        this.finalTaskList = finalTaskList;
    }

    public void setUserAccount(UserAccountDTO userAccount) {
        this.userAccount = userAccount;
    }

    public void setConfigService(TaskConfigFacadeService configService) {
        this.configService = configService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserTaskContext)) {
            return false;
        }
        UserTaskContext other = (UserTaskContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseUserParam this$param = this.getParam();
        BaseUserParam other$param = other.getParam();
        if (this$param == null ? other$param != null : !this$param.equals(other$param)) {
            return false;
        }
        Map<String, UserTaskItemBO> this$taskCacheMap = this.getTaskCacheMap();
        Map<String, UserTaskItemBO> other$taskCacheMap = other.getTaskCacheMap();
        if (this$taskCacheMap == null ? other$taskCacheMap != null : !((Object)this$taskCacheMap).equals(other$taskCacheMap)) {
            return false;
        }
        List<TaskListItemV2DTO> this$finalTaskList = this.getFinalTaskList();
        List<TaskListItemV2DTO> other$finalTaskList = other.getFinalTaskList();
        if (this$finalTaskList == null ? other$finalTaskList != null : !((Object)this$finalTaskList).equals(other$finalTaskList)) {
            return false;
        }
        UserAccountDTO this$userAccount = this.getUserAccount();
        UserAccountDTO other$userAccount = other.getUserAccount();
        if (this$userAccount == null ? other$userAccount != null : !this$userAccount.equals(other$userAccount)) {
            return false;
        }
        TaskConfigFacadeService this$configService = this.getConfigService();
        TaskConfigFacadeService other$configService = other.getConfigService();
        return !(this$configService == null ? other$configService != null : !this$configService.equals(other$configService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserTaskContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseUserParam $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : $param.hashCode());
        Map<String, UserTaskItemBO> $taskCacheMap = this.getTaskCacheMap();
        result = result * 59 + ($taskCacheMap == null ? 43 : ((Object)$taskCacheMap).hashCode());
        List<TaskListItemV2DTO> $finalTaskList = this.getFinalTaskList();
        result = result * 59 + ($finalTaskList == null ? 43 : ((Object)$finalTaskList).hashCode());
        UserAccountDTO $userAccount = this.getUserAccount();
        result = result * 59 + ($userAccount == null ? 43 : $userAccount.hashCode());
        TaskConfigFacadeService $configService = this.getConfigService();
        result = result * 59 + ($configService == null ? 43 : $configService.hashCode());
        return result;
    }

    public String toString() {
        return "UserTaskContext(param=" + this.getParam() + ", taskCacheMap=" + this.getTaskCacheMap() + ", finalTaskList=" + this.getFinalTaskList() + ", userAccount=" + this.getUserAccount() + ", configService=" + this.getConfigService() + ")";
    }

    public static class UserTaskContextBuilder {
        private BaseUserParam param;
        private Map<String, UserTaskItemBO> taskCacheMap;
        private List<TaskListItemV2DTO> finalTaskList;
        private UserAccountDTO userAccount;
        private TaskConfigFacadeService configService;

        UserTaskContextBuilder() {
        }

        public UserTaskContextBuilder param(BaseUserParam param) {
            this.param = param;
            return this;
        }

        public UserTaskContextBuilder taskCacheMap(Map<String, UserTaskItemBO> taskCacheMap) {
            this.taskCacheMap = taskCacheMap;
            return this;
        }

        public UserTaskContextBuilder finalTaskList(List<TaskListItemV2DTO> finalTaskList) {
            this.finalTaskList = finalTaskList;
            return this;
        }

        public UserTaskContextBuilder userAccount(UserAccountDTO userAccount) {
            this.userAccount = userAccount;
            return this;
        }

        public UserTaskContextBuilder configService(TaskConfigFacadeService configService) {
            this.configService = configService;
            return this;
        }

        public UserTaskContext build() {
            return new UserTaskContext(this.param, this.taskCacheMap, this.finalTaskList, this.userAccount, this.configService);
        }

        public String toString() {
            return "UserTaskContext.UserTaskContextBuilder(param=" + this.param + ", taskCacheMap=" + this.taskCacheMap + ", finalTaskList=" + this.finalTaskList + ", userAccount=" + this.userAccount + ", configService=" + this.configService + ")";
        }
    }
}

