/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.handler.UserTaskHandlerManage;
import com.bxm.dailyegg.task.model.bo.UserBubbleTaskContentBO;
import com.bxm.dailyegg.task.model.bo.UserTaskContentBO;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemDTO;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemV2DTO;
import com.bxm.dailyegg.task.model.dto.TaskListDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.entity.UserTaskFinishStatisticsEntity;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.TaskService;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final UserTaskHandlerManage userTaskHandlerManage;
    private final RedisStringAdapter redisStringAdapter;
    private final UserTaskInfoService userTaskInfoService;
    private final TaskProperties taskProperties;
    private final Map<String, AbstractUserTaskStrategy> taskStrategyMap;
    private final TaskCacheHolder taskCacheHolder;
    private final TypeReference<List<TaskListItemDTO>> typeReference = new TypeReference<List<TaskListItemDTO>>(){};
    private final TypeReference<List<BubbleTaskItemDTO>> bubbleTypeReference = new TypeReference<List<BubbleTaskItemDTO>>(){};
    private final TaskConfigFacadeService taskConfigFacadeService;

    public TaskServiceImpl(UserTaskHandlerManage userTaskHandlerManage, RedisStringAdapter redisStringAdapter, UserTaskInfoService userTaskInfoService, TaskProperties taskProperties, List<AbstractUserTaskStrategy> taskStrategyList, TaskCacheHolder taskCacheHolder, TaskConfigFacadeService taskConfigFacadeService) {
        this.userTaskHandlerManage = userTaskHandlerManage;
        this.redisStringAdapter = redisStringAdapter;
        this.userTaskInfoService = userTaskInfoService;
        this.taskProperties = taskProperties;
        this.taskCacheHolder = taskCacheHolder;
        this.taskConfigFacadeService = taskConfigFacadeService;
        this.taskStrategyMap = new HashMap<String, AbstractUserTaskStrategy>();
        for (AbstractUserTaskStrategy taskStrategy : taskStrategyList) {
            this.taskStrategyMap.put(taskStrategy.type(), taskStrategy);
        }
    }

    @Override
    public List<BubbleTaskItemDTO> fetchBubbleTaskList(BaseUserParam param) {
        KeyGenerator key = this.builderBubbleTaskKey();
        List bubbleTaskItemDTOS = (List)this.redisStringAdapter.get(key, this.bubbleTypeReference);
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        this.userTaskHandlerManage.bubbleTaskHandler(UserBubbleTaskContentBO.builder().listItemDTOS(bubbleTaskItemDTOS).originParam(param).totalFoods(userAccountInfo.getTotalFoods()).build());
        return bubbleTaskItemDTOS;
    }

    @Override
    public List<BubbleTaskItemV2DTO> fetchBubbleTaskListV2(BaseUserParam param) {
        Integer todayBubbleTaskNum = this.taskCacheHolder.getTodayBubbleTaskNum(param.getUserId());
        if (todayBubbleTaskNum >= this.taskProperties.getMaxBubbleTaskNum()) {
            return Lists.newArrayList();
        }
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), TaskActionEnum.BUBBLE_VIDEO);
        ArrayList taskItemList = Lists.newArrayList();
        for (int i = 0; i < this.taskProperties.getMaxBubbleTaskNum() - todayBubbleTaskNum && i < 5; ++i) {
            BubbleTaskItemV2DTO taskItem = new BubbleTaskItemV2DTO();
            taskItem.setTaskId(Long.valueOf(-1L));
            taskItem.setAction(TaskActionEnum.BUBBLE_VIDEO_DIRECT.name());
            taskItem.setAwardGrainNum(userAwardGrainNum);
            taskItem.setMultipleTaskId(Long.valueOf(-1L));
            taskItem.setMultipleTaskAction(TaskActionEnum.BUBBLE_VIDEO_MULTIPLE.name());
            taskItem.setDirectAwardGrainNum(Integer.valueOf(1));
            taskItem.setMultipleNum(userAwardGrainNum);
            taskItemList.add(taskItem);
        }
        return taskItemList;
    }

    private KeyGenerator builderDailyTaskKey() {
        return RedisCacheConstant.DAILY_TASK_LIST.copy();
    }

    private KeyGenerator builderBubbleTaskKey() {
        return RedisCacheConstant.BUBBLE_TASK_LIST.copy();
    }

    @Override
    public TaskListDTO fetchUserTaskList(BaseUserParam param) {
        TaskListDTO taskListDTO = new TaskListDTO();
        List taskListItemDTO = (List)this.redisStringAdapter.get(this.builderDailyTaskKey(), (TypeReference)new TypeReference<List<TaskListItemDTO>>(){});
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        this.userTaskHandlerManage.dailyTaskHandler(UserTaskContentBO.builder().originParam(param).listItemDTOS(taskListItemDTO).totalFoods(userAccountInfo.getTotalFoods()).build());
        this.userTaskInfoService.initUserTaskFinishInfo(param.getUserId(), taskListItemDTO);
        List resultList = taskListItemDTO.stream().sorted(Comparator.comparing(TaskListItemDTO::getTaskStatus)).collect(Collectors.toList());
        this.setExtendEggNum(taskListDTO, param.getUserId());
        taskListDTO.setItemList(resultList);
        return taskListDTO;
    }

    private void setExtendEggNum(TaskListDTO taskListDTO, Long userId) {
        Map<String, Integer> extFinishTaskReward = this.taskProperties.getExtFinishTaskReward();
        if (Objects.isNull(extFinishTaskReward)) {
            taskListDTO.setExtendEggNum(Integer.valueOf(0));
        } else {
            UserTaskFinishStatisticsEntity taskFinishStatistics = this.userTaskInfoService.getUserFinishDailyTaskNum(userId);
            int num = taskFinishStatistics == null ? 1 : taskFinishStatistics.getNum() + 1;
            Integer rewardEggNum = extFinishTaskReward.get(Integer.toString(num));
            taskListDTO.setExtendEggNum(Integer.valueOf(rewardEggNum == null ? 0 : rewardEggNum));
        }
    }

    @Override
    public Message completeTask(CompleteTaskParam param) {
        return this.taskStrategyMap.get(param.getAction()).doTask(param);
    }

    @Override
    public void visitAppTask(Long userId) {
        KeyGenerator key = this.builderDailyTaskKey();
        List taskListItems = (List)this.redisStringAdapter.get(key, this.typeReference);
        if (CollectionUtil.isEmpty((Collection)taskListItems)) {
            return;
        }
        Optional<TaskListItemDTO> visitTaskInfo = taskListItems.stream().filter(this::match).findFirst();
        if (!visitTaskInfo.isPresent()) {
            return;
        }
        CompleteTaskParam completeTaskParam = new CompleteTaskParam();
        completeTaskParam.setAction(TaskActionEnum.OPEN_APP_TWO.name());
        completeTaskParam.setUserId(userId);
        completeTaskParam.setTaskId(visitTaskInfo.get().getTaskId());
        this.completeTask(completeTaskParam);
    }

    private boolean match(TaskListItemDTO item) {
        return TaskActionEnum.OPEN_APP_TWO.name().equals(item.getAction());
    }
}

