/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.service.impl;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.common.model.param.BaseUserParam;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.BubbleTaskItemV3DTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemV2DTO;
import com.bxm.dailyegg.task.service.TaskV3Service;
import com.bxm.dailyegg.task.service.context.UserTaskContext;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.facade.UserAccountFacadeService;
import com.bxm.newidea.component.filter.LogicFilterChainExecutor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskV3ServiceImpl
implements TaskV3Service {
    private static final Logger log = LoggerFactory.getLogger(TaskV3ServiceImpl.class);
    private TaskCacheHolder taskCacheHolder;
    private TaskProperties taskProperties;
    private UserAccountFacadeService userAccountFacadeService;
    private TaskConfigFacadeService taskConfigFacadeService;
    private LogicFilterChainExecutor logicFilterChainExecutor;

    @Override
    public List<BubbleTaskItemV3DTO> fetchBubbleTaskListV3(BaseUserParam param) {
        Map<String, Integer> todayBubbleV3Map = this.taskCacheHolder.getTodayBubbleV3(param.getUserId());
        int freeBubble = this.taskProperties.getBubbleTaskShowNum() / 2;
        int todayFreeBubbleNum = todayBubbleV3Map.getOrDefault(TaskActionEnum.BUBBLE_VIDEO_DIRECT_V3.name(), 0);
        int lastFreeBubbleNum = this.taskProperties.getMaxFreeBubble() - todayFreeBubbleNum;
        freeBubble = Math.min(freeBubble, lastFreeBubbleNum);
        int videoBubble = this.taskProperties.getBubbleTaskShowNum() - freeBubble;
        int todayVideoBubbleNum = todayBubbleV3Map.getOrDefault(TaskActionEnum.BUBBLE_VIDEO_V3.name(), 0);
        int lastVideoBubbleNum = this.taskProperties.getMaxVideoBubble() - todayVideoBubbleNum;
        videoBubble = Math.min(videoBubble, lastVideoBubbleNum);
        UserAccountDTO userAccountDTO = this.userAccountFacadeService.loadUserAccount(param.getUserId());
        ArrayList result = Lists.newArrayList();
        this.fillFreeBubble(result, freeBubble, userAccountDTO);
        this.fillVideoBubble(result, videoBubble, userAccountDTO);
        Collections.shuffle(result);
        return result;
    }

    private void fillVideoBubble(List<BubbleTaskItemV3DTO> result, int videoBubble, UserAccountDTO userAccountDTO) {
        if (videoBubble > 0) {
            Integer videoAwardNum = this.taskConfigFacadeService.getAwardConfig(userAccountDTO.getTotalFoods(), TaskActionEnum.BUBBLE_VIDEO_V3);
            for (int i = 0; i < videoBubble; ++i) {
                BubbleTaskItemV3DTO item = new BubbleTaskItemV3DTO();
                item.setTaskId(Long.valueOf(-1L));
                item.setAwardGrainNum(videoAwardNum);
                item.setAction(TaskActionEnum.BUBBLE_VIDEO_V3.name());
                item.setIcon(this.taskProperties.getVideoBubbleIconUrl());
                result.add(item);
            }
        }
    }

    private void fillFreeBubble(List<BubbleTaskItemV3DTO> result, int freeBubble, UserAccountDTO userAccountDTO) {
        if (freeBubble <= 0) {
            return;
        }
        Integer freeAwardNum = this.taskConfigFacadeService.getAwardConfig(userAccountDTO.getTotalFoods(), TaskActionEnum.BUBBLE_VIDEO_DIRECT_V3);
        for (int i = 0; i < freeBubble; ++i) {
            BubbleTaskItemV3DTO item = new BubbleTaskItemV3DTO();
            item.setTaskId(Long.valueOf(-1L));
            item.setAwardGrainNum(freeAwardNum);
            item.setAction(TaskActionEnum.BUBBLE_VIDEO_DIRECT_V3.name());
            item.setIcon(this.taskProperties.getFreeBubbleIconUrl());
            result.add(item);
        }
    }

    @Override
    public List<TaskListItemV2DTO> fetchList(BaseUserParam param) {
        UserAccountDTO userAccountDTO = this.userAccountFacadeService.loadUserAccount(param.getUserId());
        Map<String, UserTaskItemBO> cacheTaskMap = this.taskCacheHolder.fetchUserTask(param.getUserId());
        UserTaskContext context = UserTaskContext.builder().param(param).userAccount(userAccountDTO).configService(this.taskConfigFacadeService).finalTaskList(Lists.newArrayList()).taskCacheMap(cacheTaskMap).build();
        this.logicFilterChainExecutor.doFilter("USER_TASK_FILTER", (Object)context);
        List<TaskListItemV2DTO> finalTaskList = context.getFinalTaskList();
        for (TaskListItemV2DTO taskListItemV2DTO : finalTaskList) {
            if (!taskListItemV2DTO.getFinish().booleanValue()) continue;
            taskListItemV2DTO.setTaskClickAction("NONE");
            if (taskListItemV2DTO.getOrder() <= 0) {
                taskListItemV2DTO.setOrder(Integer.valueOf(1));
            }
            taskListItemV2DTO.setOrder(Integer.valueOf(taskListItemV2DTO.getOrder() * 100));
        }
        return finalTaskList.stream().sorted().collect(Collectors.toList());
    }

    public TaskV3ServiceImpl(TaskCacheHolder taskCacheHolder, TaskProperties taskProperties, UserAccountFacadeService userAccountFacadeService, TaskConfigFacadeService taskConfigFacadeService, LogicFilterChainExecutor logicFilterChainExecutor) {
        this.taskCacheHolder = taskCacheHolder;
        this.taskProperties = taskProperties;
        this.userAccountFacadeService = userAccountFacadeService;
        this.taskConfigFacadeService = taskConfigFacadeService;
        this.logicFilterChainExecutor = logicFilterChainExecutor;
    }
}

