/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.service.impl;

import com.bxm.dailyegg.common.constant.TaskCommonConstant;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.model.domain.UserTaskFinishStatisticsMapper;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.entity.UserTaskFinishStatisticsEntity;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.facade.UserAccountFacadeService;
import com.bxm.dailyegg.user.param.UserAccountOpsParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserTaskInfoServiceImpl
implements UserTaskInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserTaskInfoServiceImpl.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserTaskFinishStatisticsMapper userTaskFinishStatisticsMapper;
    private final TaskProperties taskProperties;
    private final UserAccountFacadeService userAccountFacadeService;
    private final TaskCacheHolder taskCacheHolder;

    @Override
    public Integer getUserDailyTaskFinishNum(Long userId, Long taskId) {
        Integer userTaskFinish = (Integer)this.redisHashMapAdapter.get(this.builderDailyTaskKey(userId), taskId.toString(), Integer.class);
        return userTaskFinish == null || userTaskFinish == 0 ? 0 : userTaskFinish;
    }

    private KeyGenerator builderDailyTaskKey(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_DAILY_TASK_NUM.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    private KeyGenerator builderBubbleTaskKey(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_BUBBLE_TASK_NUM.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    private KeyGenerator builderUserDailyTaskFinishInfo(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_DAILY_TASK_FINISH_INFO.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    @Override
    public Boolean bubbleTaskFinish(Long userId, Long taskId) {
        Integer userTaskFinish = (Integer)this.redisHashMapAdapter.get(this.builderBubbleTaskKey(userId), taskId.toString(), Integer.class);
        return userTaskFinish == null || userTaskFinish == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    @Override
    public Boolean dailyTaskFinish(Long userId, Long taskId) {
        Boolean userTaskFinishInfo = (Boolean)this.redisHashMapAdapter.get(this.builderUserDailyTaskFinishInfo(userId), taskId.toString(), Boolean.class);
        return Objects.equals(userTaskFinishInfo, Boolean.TRUE);
    }

    @Override
    public void initUserTaskFinishInfo(Long userId, List<TaskListItemDTO> taskListItemDTO) {
        KeyGenerator key = this.builderUserDailyTaskFinishInfo(userId);
        if (!this.redisHashMapAdapter.hasKey(key).booleanValue()) {
            HashMap<String, Boolean> taskMap = new HashMap<String, Boolean>();
            for (TaskListItemDTO listItemDTO : taskListItemDTO) {
                taskMap.put(listItemDTO.getTaskId().toString(), Boolean.FALSE);
            }
            taskMap.put(TaskCommonConstant.GUIDE_TASK_ID.toString(), this.taskCacheHolder.hasGuideAwardRecord(userId));
            this.redisHashMapAdapter.putAll(key, taskMap);
            this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
        }
    }

    @Override
    public UserTaskFinishStatisticsEntity getUserFinishDailyTaskNum(Long userId) {
        return this.userTaskFinishStatisticsMapper.getUserTaskFinishInfo(userId);
    }

    @Override
    public Message sendFoodsAndLog(UserAccountOpsParam userAccountOpsParam) {
        return this.userAccountFacadeService.changeAccount(userAccountOpsParam);
    }

    @Override
    public void updateUserExtFinishNum(Long userId, Integer currNum) {
        if (currNum == null) {
            UserTaskFinishStatisticsEntity userTaskFinishStatisticsEntity = new UserTaskFinishStatisticsEntity();
            userTaskFinishStatisticsEntity.setCreateTime(new Date());
            userTaskFinishStatisticsEntity.setNum(Integer.valueOf(1));
            userTaskFinishStatisticsEntity.setUserId(userId);
            userTaskFinishStatisticsEntity.setModifyTime(new Date());
            this.userTaskFinishStatisticsMapper.insert((Object)userTaskFinishStatisticsEntity);
        } else {
            this.userTaskFinishStatisticsMapper.updateUserFinishTaskNum(userId, currNum);
        }
    }

    @Override
    public UserAccountDTO getUserAccountInfo(Long userId) {
        return this.userAccountFacadeService.loadUserAccount(userId);
    }

    public UserTaskInfoServiceImpl(RedisHashMapAdapter redisHashMapAdapter, UserTaskFinishStatisticsMapper userTaskFinishStatisticsMapper, TaskProperties taskProperties, UserAccountFacadeService userAccountFacadeService, TaskCacheHolder taskCacheHolder) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userTaskFinishStatisticsMapper = userTaskFinishStatisticsMapper;
        this.taskProperties = taskProperties;
        this.userAccountFacadeService = userAccountFacadeService;
        this.taskCacheHolder = taskCacheHolder;
    }
}

