/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy;

import com.bxm.dailyegg.common.config.CommonConfigProperties;
import com.bxm.dailyegg.common.enums.AccountOpsTypeEnum;
import com.bxm.dailyegg.common.enums.FoodsFlowTypeEnum;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.IUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.dailyegg.user.param.UserAccountOpsParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractUserTaskStrategy
implements IUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractUserTaskStrategy.class);
    @Resource
    private UserTaskInfoService userTaskInfoService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private TaskProperties taskProperties;
    @Resource
    private CommonConfigProperties commonProperties;
    private TypeReference<List<TaskListItemDTO>> typeReference = new TypeReference<List<TaskListItemDTO>>(){};

    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        return Message.build((boolean)Boolean.TRUE);
    }

    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        return Message.build((boolean)Boolean.TRUE);
    }

    public abstract String type();

    @Override
    public Message doTask(CompleteTaskParam completeTaskParam) {
        Message beforeAuthenticationResult = this.beforeUserTaskAuthentication(completeTaskParam);
        if (!beforeAuthenticationResult.isSuccess()) {
            return beforeAuthenticationResult;
        }
        return this.afterUserTaskHandler(completeTaskParam);
    }

    protected Message sendFoods(Long userId, Integer foodsNum, String remark) {
        UserAccountOpsParam param = new UserAccountOpsParam();
        param.setUserId(userId);
        param.setNum(foodsNum);
        param.setOpsType(AccountOpsTypeEnum.ADD_FOOD);
        param.setFlowTypeEnum(FoodsFlowTypeEnum.ADD_FOODS);
        param.setRemark(remark);
        return this.userTaskInfoService.sendFoodsAndLog(param);
    }

    protected TaskListItemDTO getTaskInfo(String action) {
        List taskListItemList = (List)this.redisStringAdapter.get(RedisCacheConstant.DAILY_TASK_LIST.copy(), this.typeReference);
        Optional<TaskListItemDTO> taskListItem = taskListItemList.stream().filter(taskListItemDTO -> taskListItemDTO.getAction().equals(action)).findFirst();
        return taskListItem.orElse(null);
    }

    protected KeyGenerator builderDailyTaskKey(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_DAILY_TASK_NUM.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    protected KeyGenerator builderUserDailyTaskFinishInfo(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_DAILY_TASK_FINISH_INFO.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    protected KeyGenerator builderBubbleTaskKey(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_BUBBLE_TASK_NUM.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    protected void hasAd(CompleteTaskParam param, UserAccountDTO accountDTO, CompleteTaskDTO taskDTO) {
        if (accountDTO == null) {
            accountDTO = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        }
        if (null != taskDTO) {
            taskDTO.setShowAd(Boolean.valueOf(accountDTO.getTotalFoods() > this.commonProperties.getShowAdCriticalValue()));
        }
    }

    protected void extTaskReward(Long userId) {
    }
}

