/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingleTaskV3ActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractSingleTaskV3ActionStrategy.class);
    @Resource
    private TaskCacheHolder taskCacheHolder;
    @Resource
    private UserTaskInfoService userTaskInfoService;
    @Resource
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam param) {
        Map<String, UserTaskItemBO> cacheTaskMap = this.taskCacheHolder.fetchUserTask(param.getUserId());
        UserTaskItemBO cacheTaskItem = cacheTaskMap.get(this.getAction().name());
        if (null == cacheTaskItem) {
            log.error("\u4efb\u52a1\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5b8c\u6210,\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
            return Message.build((boolean)false, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (cacheTaskItem.getCurrent() >= cacheTaskItem.getMax()) {
            return Message.build((boolean)false, (String)"\u5df2\u8fbe\u5230\u4eca\u65e5\u4efb\u52a1\u6570\u91cf\u4e0a\u9650");
        }
        return Message.build();
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam param) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), this.getAction());
        Message message = this.sendFoods(param.getUserId(), userAwardGrainNum, this.flowRemark());
        if (!message.isSuccess()) {
            return message;
        }
        this.taskCacheHolder.addTaskTimes(param.getUserId(), this.getAction());
        CompleteTaskDTO responseTask = new CompleteTaskDTO();
        responseTask.setAwardNum(userAwardGrainNum);
        this.hasAd(param, userAccountInfo, responseTask);
        return Message.build().addParam("resultDTO", (Object)responseTask);
    }

    protected abstract TaskActionEnum getAction();

    protected abstract String flowRemark();

    @Override
    public String type() {
        return this.getAction().name();
    }
}

