/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.bo.UserTaskItemBO;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.bo.Message;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractV3TaskActionHandler
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractV3TaskActionHandler.class);
    @Resource
    protected TaskCacheHolder taskCacheHolder;
    @Resource
    protected TaskProperties taskProperties;
    @Resource
    protected UserTaskInfoService userTaskInfoService;
    @Resource
    protected TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam param) {
        Map<String, UserTaskItemBO> cacheTaskMap = this.taskCacheHolder.fetchUserTask(param.getUserId());
        UserTaskItemBO cacheTaskItem = cacheTaskMap.get(this.getAction().name());
        if (null == cacheTaskItem || cacheTaskItem.getFinish().booleanValue()) {
            log.error("\u4efb\u52a1\u4e0d\u5b58\u5728,\u65e0\u6cd5\u5b8c\u6210,\u8bf7\u6c42\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param));
            return Message.build((boolean)false, (String)"\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5b8c\u6210");
        }
        if (cacheTaskItem.getManual().booleanValue() && cacheTaskItem.getCurrent() < cacheTaskItem.getMax()) {
            return Message.build((boolean)false, (String)"\u6ca1\u6709\u672a\u8fbe\u6807\uff0c\u65e0\u6cd5\u9886\u53d6\u5956\u52b1");
        }
        return Message.build();
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam param) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), this.getAction());
        Message message = this.sendFoods(param.getUserId(), userAwardGrainNum, this.flowRemark());
        if (!message.isSuccess()) {
            return message;
        }
        this.taskCacheHolder.setTaskFinish(param.getUserId(), this.getAction());
        CompleteTaskDTO responseTask = new CompleteTaskDTO();
        responseTask.setAwardNum(userAwardGrainNum);
        this.hasAd(param, userAccountInfo, responseTask);
        return Message.build().addParam("resultDTO", (Object)responseTask);
    }

    protected abstract TaskActionEnum getAction();

    protected abstract String flowRemark();

    @Override
    public String type() {
        return this.getAction().name();
    }
}

