/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BubbleFreeTaskV3ActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(BubbleFreeTaskV3ActionStrategy.class);
    private final TaskCacheHolder taskCacheHolder;
    private final TaskProperties taskProperties;
    private final UserTaskInfoService userTaskInfoService;
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Map<String, Integer> todayBubbleV3 = this.taskCacheHolder.getTodayBubbleV3(completeTaskParam.getUserId());
        int todayNum = todayBubbleV3.getOrDefault(this.getAction().name(), 0);
        if (todayNum >= this.taskProperties.getMaxFreeBubble()) {
            log.error("\u7528\u6237[{}]\u5b8c\u6210\u4e86\u8d85\u51fa\u6570\u91cf\u7684\u6c14\u6ce1\u4efb\u52a1,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u903b\u8f91\u95ee\u9898", (Object)completeTaskParam.getUserId());
            return Message.build((boolean)false, (String)"\u5df2\u8fbe\u5230\u4eca\u65e5\u4efb\u52a1\u6570\u91cf\u4e0a\u9650");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam param) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(param.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), this.getAction());
        Message message = this.sendFoods(param.getUserId(), userAwardGrainNum, "\u6c14\u6ce1\u4efb\u52a1\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        this.taskCacheHolder.addTodayBubbleV3Times(param.getUserId(), this.getAction());
        CompleteTaskDTO responseTask = new CompleteTaskDTO();
        responseTask.setAwardNum(userAwardGrainNum);
        this.hasAd(param, userAccountInfo, responseTask);
        return Message.build().addParam("resultDTO", (Object)responseTask);
    }

    private TaskActionEnum getAction() {
        return TaskActionEnum.BUBBLE_VIDEO_DIRECT_V3;
    }

    @Override
    public String type() {
        return this.getAction().name();
    }

    public BubbleFreeTaskV3ActionStrategy(TaskCacheHolder taskCacheHolder, TaskProperties taskProperties, UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.taskCacheHolder = taskCacheHolder;
        this.taskProperties = taskProperties;
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

