/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BubbleVideoTaskActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(BubbleVideoTaskActionStrategy.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserTaskInfoService userTaskInfoService;
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        KeyGenerator key = this.builderBubbleTaskKey(completeTaskParam.getUserId());
        Integer currNum = (Integer)this.redisHashMapAdapter.get(key, completeTaskParam.getTaskId().toString(), Integer.class);
        if (Objects.nonNull(currNum) && currNum >= 1) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u6b64\u6c14\u6ce1\u4efb\u52a1\u5df2\u5b8c\u6210");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), TaskActionEnum.BUBBLE_VIDEO);
        Message message = this.sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "\u6c14\u6ce1\u4efb\u52a1\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        KeyGenerator key = this.builderBubbleTaskKey(completeTaskParam.getUserId());
        this.redisHashMapAdapter.put(key, completeTaskParam.getTaskId().toString(), (Object)1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        return Message.build().addParam("resultDTO", (Object)completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.BUBBLE_VIDEO.name();
    }

    public BubbleVideoTaskActionStrategy(RedisHashMapAdapter redisHashMapAdapter, UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

