/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BubbleVideoTaskMultipleActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(BubbleVideoTaskMultipleActionStrategy.class);
    private final TaskCacheHolder taskCacheHolder;
    private final TaskProperties taskProperties;
    private final UserTaskInfoService userTaskInfoService;
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Integer todayBubbleTaskNum = this.taskCacheHolder.getTodayBubbleTaskNum(completeTaskParam.getUserId());
        if (todayBubbleTaskNum >= this.taskProperties.getMaxBubbleTaskNum()) {
            log.error("\u7528\u6237[{}]\u5b8c\u6210\u4e86\u8d85\u51fa\u6570\u91cf\u7684\u6c14\u6ce1\u4efb\u52a1,\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u903b\u8f91\u95ee\u9898", (Object)completeTaskParam.getUserId());
            return Message.build((boolean)false, (String)"\u5df2\u8fbe\u5230\u4eca\u65e5\u4efb\u52a1\u6570\u91cf\u4e0a\u9650");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), TaskActionEnum.BUBBLE_VIDEO);
        Message message = this.sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "\u7ffb\u500d\u6c14\u6ce1\u4efb\u52a1\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        this.taskCacheHolder.addUserBubbleTask(completeTaskParam.getUserId());
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        this.hasAd(completeTaskParam, userAccountInfo, completeTaskDTO);
        return Message.build().addParam("resultDTO", (Object)completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.BUBBLE_VIDEO_MULTIPLE.name();
    }

    public BubbleVideoTaskMultipleActionStrategy(TaskCacheHolder taskCacheHolder, TaskProperties taskProperties, UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.taskCacheHolder = taskCacheHolder;
        this.taskProperties = taskProperties;
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

