/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.newidea.component.bo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExtGrantGrainActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExtGrantGrainActionStrategy.class);
    private final TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        Integer awardNum = this.taskConfigFacadeService.getAwardConfigWithUserId(completeTaskParam.getUserId(), TaskActionEnum.EXT_GRANT_GIFT_REWARD);
        Message message = this.sendFoods(completeTaskParam.getUserId(), awardNum, "\u989d\u5916\u7cae\u98df\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setAwardNum(awardNum);
        return Message.build().addParam("resultDTO", (Object)completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.EXT_GRANT_GRAIN_REWARD.name();
    }

    public ExtGrantGrainActionStrategy(TaskConfigFacadeService taskConfigFacadeService) {
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

