/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.cache.TaskCacheHolder;
import com.bxm.dailyegg.task.config.TaskProperties;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GuideTaskActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(GuideTaskActionStrategy.class);
    private TaskProperties taskProperties;
    private TaskCacheHolder taskCacheHolder;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        if (this.taskCacheHolder.hasGuideAwardRecord(completeTaskParam.getUserId())) {
            return Message.build((boolean)false, (String)"\u5df2\u7ecf\u53d1\u653e\u8fc7\u89c2\u770b\u9886\u86cb\u79d8\u7c4d\u7684\u5956\u52b1");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        Integer userAwardGrainNum = this.taskProperties.getGuideAwardNum();
        Message message = this.sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "\u89c2\u770b\u9886\u86cb\u79d8\u7c4d");
        if (!message.isSuccess()) {
            return message;
        }
        this.taskCacheHolder.addGuideAwardRecord(completeTaskParam.getUserId());
        this.redisHashMapAdapter.put(this.builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), (Object)Boolean.TRUE);
        this.extTaskReward(completeTaskParam.getUserId());
        Message build = Message.build();
        build.setSuccess(Boolean.TRUE.booleanValue());
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("\u4efb\u52a1\u5b8c\u6210");
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        build.addParam("resultDTO", (Object)completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.GUIDE_VIDEO.name();
    }

    public GuideTaskActionStrategy(TaskProperties taskProperties, TaskCacheHolder taskCacheHolder, RedisHashMapAdapter redisHashMapAdapter) {
        this.taskProperties = taskProperties;
        this.taskCacheHolder = taskCacheHolder;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }
}

