/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.constant.RedisCacheConstant;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OpenAppTwoTaskActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(OpenAppTwoTaskActionStrategy.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final RedisStringAdapter redisStringAdapter;
    private final UserTaskInfoService userTaskInfoService;
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Integer time = (Integer)this.redisStringAdapter.get(this.builderUserOpenAppTime(completeTaskParam.getUserId()), Integer.class);
        if (Objects.nonNull(time)) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u6b64\u4efb\u52a1,\u4e24\u6b21\u95f4\u9694\u81f3\u5c1110\u5206\u949f");
        }
        this.redisHashMapAdapter.increment(this.builderDailyTaskKey(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), 1);
        this.redisHashMapAdapter.expire(this.builderDailyTaskKey(completeTaskParam.getUserId()), (long)DateUtils.getCurSeconds());
        this.redisStringAdapter.set(this.builderUserOpenAppTime(completeTaskParam.getUserId()), 1L);
        this.redisStringAdapter.expire(this.builderUserOpenAppTime(completeTaskParam.getUserId()), 600L);
        Long taskId = completeTaskParam.getTaskId();
        Integer openAppNum = this.userTaskInfoService.getUserDailyTaskFinishNum(completeTaskParam.getUserId(), taskId);
        if (openAppNum > 2) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u6b64\u4efb\u52a1\u5df2\u5b8c\u6210,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        if (openAppNum < 2) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u6b64\u4efb\u52a1\u5df2\u672a\u5b8c\u6210,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    private KeyGenerator builderUserOpenAppTime(Long userId) {
        String date = DateUtils.formatDate((Date)new Date());
        return RedisCacheConstant.USER_OPEN_APP_TIME.copy().appendKey((Object)userId).appendKey((Object)date);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), TaskActionEnum.OPEN_APP_TWO);
        Message message = this.sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "\u6253\u5f00\u4e24\u6b21APP\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        this.redisHashMapAdapter.put(this.builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), (Object)Boolean.TRUE);
        this.extTaskReward(completeTaskParam.getUserId());
        Message build = Message.build();
        build.setSuccess(Boolean.TRUE.booleanValue());
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("\u9886\u53d6\u6210\u529f");
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        build.addParam("resultDTO", (Object)completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.OPEN_APP_TWO.name();
    }

    public OpenAppTwoTaskActionStrategy(RedisHashMapAdapter redisHashMapAdapter, RedisStringAdapter redisStringAdapter, UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

