/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.model.param.PointParam;
import com.bxm.newidea.component.param.BasicParam;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.util.PointReportUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignTaskActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(SignTaskActionStrategy.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserTaskInfoService userTaskInfoService;
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Boolean currSign = (Boolean)this.redisHashMapAdapter.get(this.builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), Boolean.class);
        if (Objects.equals(currSign, Boolean.TRUE)) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u7528\u6237\u5f53\u5929\u5df2\u7b7e\u5230");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), TaskActionEnum.SIGN);
        Message message = this.sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "\u7b7e\u5230\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        this.redisHashMapAdapter.increment(this.builderDailyTaskKey(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), 1);
        this.redisHashMapAdapter.expire(this.builderDailyTaskKey(completeTaskParam.getUserId()), (long)DateUtils.getCurSeconds());
        this.redisHashMapAdapter.put(this.builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), (Object)Boolean.TRUE);
        this.extTaskReward(completeTaskParam.getUserId());
        Message build = Message.build();
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("\u7b7e\u5230\u6210\u529f");
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        this.hasAd(completeTaskParam, userAccountInfo, completeTaskDTO);
        PointReportUtils.report((PointParam)PointParam.build((BasicParam)completeTaskParam).project("daily").event(3034).eventValue("103").userId(completeTaskParam.getUserId()));
        build.addParam("resultDTO", (Object)completeTaskDTO);
        return build;
    }

    @Override
    public String type() {
        return TaskActionEnum.SIGN.name();
    }

    public SignTaskActionStrategy(RedisHashMapAdapter redisHashMapAdapter, UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

