/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.dailyegg.task.strategy.action;

import com.bxm.dailyegg.common.enums.TaskActionEnum;
import com.bxm.dailyegg.task.facade.TaskConfigFacadeService;
import com.bxm.dailyegg.task.model.dto.CompleteTaskDTO;
import com.bxm.dailyegg.task.model.dto.TaskListItemDTO;
import com.bxm.dailyegg.task.model.param.CompleteTaskParam;
import com.bxm.dailyegg.task.service.UserTaskInfoService;
import com.bxm.dailyegg.task.strategy.AbstractUserTaskStrategy;
import com.bxm.dailyegg.user.dto.UserAccountDTO;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WelfareVideoTaskActionStrategy
extends AbstractUserTaskStrategy {
    private static final Logger log = LoggerFactory.getLogger(WelfareVideoTaskActionStrategy.class);
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final UserTaskInfoService userTaskInfoService;
    private TaskConfigFacadeService taskConfigFacadeService;

    @Override
    protected Message beforeUserTaskAuthentication(CompleteTaskParam completeTaskParam) {
        Long taskId = completeTaskParam.getTaskId();
        Integer videoNum = this.userTaskInfoService.getUserDailyTaskFinishNum(completeTaskParam.getUserId(), taskId);
        TaskListItemDTO taskInfo = this.getTaskInfo(TaskActionEnum.WELFARE_VIDEO.name());
        if (videoNum >= taskInfo.getMaxTimes()) {
            return Message.build((boolean)Boolean.FALSE).setMessage("\u6b64\u4efb\u52a1\u5df2\u5b8c\u6210,\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        return Message.build((boolean)Boolean.TRUE);
    }

    @Override
    protected Message afterUserTaskHandler(CompleteTaskParam completeTaskParam) {
        UserAccountDTO userAccountInfo = this.userTaskInfoService.getUserAccountInfo(completeTaskParam.getUserId());
        Integer userAwardGrainNum = this.taskConfigFacadeService.getAwardConfig(userAccountInfo.getTotalFoods(), TaskActionEnum.WELFARE_VIDEO);
        Message message = this.sendFoods(completeTaskParam.getUserId(), userAwardGrainNum, "\u89c2\u770b\u798f\u5229\u89c6\u9891\u5956\u52b1");
        if (!message.isSuccess()) {
            return message;
        }
        this.redisHashMapAdapter.increment(this.builderDailyTaskKey(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), 1);
        this.redisHashMapAdapter.expire(this.builderDailyTaskKey(completeTaskParam.getUserId()), (long)DateUtils.getCurSeconds());
        TaskListItemDTO taskInfo = this.getTaskInfo(TaskActionEnum.WELFARE_VIDEO.name());
        Integer currNum = (Integer)this.redisHashMapAdapter.get(this.builderDailyTaskKey(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), Integer.class);
        if (Objects.equals(taskInfo.getMaxTimes(), currNum)) {
            this.redisHashMapAdapter.put(this.builderUserDailyTaskFinishInfo(completeTaskParam.getUserId()), completeTaskParam.getTaskId().toString(), (Object)Boolean.TRUE);
        }
        this.extTaskReward(completeTaskParam.getUserId());
        CompleteTaskDTO completeTaskDTO = new CompleteTaskDTO();
        completeTaskDTO.setTitle("\u9886\u53d6\u6210\u529f");
        completeTaskDTO.setAwardNum(userAwardGrainNum);
        this.hasAd(completeTaskParam, userAccountInfo, completeTaskDTO);
        return Message.build().addParam("resultDTO", (Object)completeTaskDTO);
    }

    @Override
    public String type() {
        return TaskActionEnum.WELFARE_VIDEO.name();
    }

    public WelfareVideoTaskActionStrategy(RedisHashMapAdapter redisHashMapAdapter, UserTaskInfoService userTaskInfoService, TaskConfigFacadeService taskConfigFacadeService) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.userTaskInfoService = userTaskInfoService;
        this.taskConfigFacadeService = taskConfigFacadeService;
    }
}

