package com.bxm.datapark.facade.activity;

import com.bxm.datapark.facade.Page;

import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * Created by wuwenquan on 2018/6/20.
 */
@FeignClient(name="datapark")
public interface ActivityReportService {

    @RequestMapping(value = "/newActivityReport",method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<ActivityReportVo>> findActivityReportByParms(@RequestBody ActivityReportDto dto);

    @RequestMapping(value="/newActivityReportExport",method = RequestMethod.POST,consumes = "application/json")
    ResultModel<List<ActivityReportVo>> newActivityReportExport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报
     * @param dto
     * @return ResultModel<Page<ActivityCountVo>>
     */
    @RequestMapping(value = "/activity", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<ActivityCountVo>> activityReport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报导出
     * @param dto
     * @return ResultModel<List<ActivityCountVo>>
     */
    @RequestMapping(value = "/activity/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountVo>> activityReportExport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报-开发者报表
     * @param dto 查询条件
     * @return ResultModel<Page<ActivityCountVo>>
     */
    @RequestMapping(value = "/activity/app", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<ActivityCountVo>> activityAppReport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报-开发者报表 导出
     * @param dto 查询条件
     * @return ResultModel<List<ActivityCountVo>>
     */
    @RequestMapping(value = "/activity/app/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountVo>> activityAppReportExport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报-按日
     * @param dto
     * @return
     */
    @RequestMapping(value = "/activity/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountVo>> activityDateReport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报-开发者-子链接报表
     * @param dto 查询条件
     * @return ResultModel<Page<ActivityCountVo>>
     */
    @RequestMapping(value = "/activity/business", method = RequestMethod.POST, consumes="application/json")
    ResultModel<Page<ActivityCountVo>> activityAppBusinessReport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报-开发者-子链接报表导出
     * @param dto
     * @return
     */
    @RequestMapping(value = "/activity/business/export", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountVo>> activityAppBusinessReportExport(@RequestBody ActivityReportDto dto);

    /**
     * 活动日报-开发者-子链接-按日报表
     * @param dto
     * @return
     */
    @RequestMapping(value = "/activity/business/date", method = RequestMethod.POST, consumes="application/json")
    ResultModel<List<ActivityCountVo>> activityAppBusinessDateReport(@RequestBody ActivityReportDto dto);

}
