package com.bxm.datapark.facade.position.model.dto;

import java.io.Serializable;

/**
* @Title:PositionSpareTicket.java
* @Package:com.bxm.datapark.model.mongo.vo.position
* @Description: 广告位备用券实体类
* @date:2018年8月8日 下午6:08:29
 */
public class PositionSpareTicketDto implements Serializable{
    
    private static final long serialVersionUID = 7503681771826372662L;
    
    private String collectionName = "ad_app_business_spare_today_stat";
    /**
     * 开始时间
     */
    private String startTime;
    
    /**
     * 结束时间
     */
    private String endTime;
    /**
     * 广告位ID
     */
    private String positionId;
    
    /**
     * 排除查询的广告位的集合
     */
    private String excludePositionIds;
    
    /**
     * 媒体名称
     */
    private String appNname;
    
    /**
     * 广告位名称
     */
    private String appEntranceName;
    
    /**
     * 媒介
     */
    private String medium;
    
    /**
     * 发券量
     */
    private Double openPv;
    
    /**
     * 备用券发券占比
     */
    private Double spareOpenProportion;
    
    /**
     * 备用券发券占比(最大)
     */
    private Double spareOpenProportionMax;
    
    /**
     * 备用券发券占比(最小)
     */
    private Double spareOpenProportionMin;
    
    /**
     * 页面号
     */
    private Integer pageNum = 1;
    
    /**
     * 页面大小
     */
    private Integer pageSize = 20;
    
    public String getCollectionName() {
        return collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getPositionId() {
        return positionId;
    }

    public void setPositionId(String positionId) {
        this.positionId = positionId;
    }

    public String getAppNname() {
        return appNname;
    }

    public void setAppNname(String appNname) {
        this.appNname = appNname;
    }

    public String getAppEntranceName() {
        return appEntranceName;
    }

    public void setAppEntranceName(String appEntranceName) {
        this.appEntranceName = appEntranceName;
    }

    public String getMedium() {
        return medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public Double getOpenPv() {
        return openPv;
    }

    public void setOpenPv(Double openPv) {
        this.openPv = openPv;
    }

    public Double getSpareOpenProportion() {
        return spareOpenProportion;
    }

    public void setSpareOpenProportion(Double spareOpenProportion) {
        this.spareOpenProportion = spareOpenProportion;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getExcludePositionIds() {
        return excludePositionIds;
    }

    public void setExcludePositionIds(String excludePositionIds) {
        this.excludePositionIds = excludePositionIds;
    }

    public Double getSpareOpenProportionMax() {
        return spareOpenProportionMax;
    }

    public void setSpareOpenProportionMax(Double spareOpenProportionMax) {
        this.spareOpenProportionMax = spareOpenProportionMax;
    }

    public Double getSpareOpenProportionMin() {
        return spareOpenProportionMin;
    }
    
    public void setSpareOpenProportionMin(Double spareOpenProportionMin) {
        this.spareOpenProportionMin = spareOpenProportionMin;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
    
}
