package com.bxm.datapark.facade.ticket.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.ticket.model.dto.AnalysisParamsDTO;
import com.bxm.datapark.facade.ticket.model.vo.analysis.*;
import com.bxm.util.dto.ResultModel;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Map;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/9 10:55
 * 修 改 人：
 * 日 期：
 * 描 述：广告券数据统计 接口
 * 版 本 号： v1
 */
@FeignClient(name = "datapark")
public interface TicketAnalysisService {

    /**
     * Description: 趋势维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/trend", method = RequestMethod.POST)
    ResultModel<Page<AnalysisTrendVO>> trend(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 媒体维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/media", method = RequestMethod.POST)
    ResultModel<Page<AnalysisMediaVO>> media(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 区域维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/region", method = RequestMethod.POST)
    ResultModel<Page<AnalysisRegionVO>> region(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 广告类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/tagType", method = RequestMethod.POST)
    ResultModel<Page<AnalysisTagTypeVO>> tagType(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 操作系统维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/appOS", method = RequestMethod.POST)
    ResultModel<Page<AnalysisAppOSVO>> appOS(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 支付类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/paymentType", method = RequestMethod.POST)
    ResultModel<Page<AnalysisPaymentTypeVO>> paymentType(AnalysisParamsDTO paramsDTO);


    //
    //  下面是图表数据的接口
    //

    /**
     * Description: 趋势维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/trend", method = RequestMethod.POST)
    ResultModel<Map<String, Map<String, Double>>> trendChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 媒体维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/media", method = RequestMethod.POST)
    ResultModel<Map<String, Map<String, Double>>> mediaChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 区域维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/region", method = RequestMethod.POST)
    ResultModel<Map<String, Map<String, Double>>> regionChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 广告类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/tagType", method = RequestMethod.POST)
    ResultModel<Map<String, Map<String, Double>>> tagTypeChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 操作系统维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/appOS", method = RequestMethod.POST)
    ResultModel<Map<String, Map<String, Double>>> appOSChart(AnalysisParamsDTO paramsDTO);

    /**
     * Description: 支付类型维度分析
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/9 11:01
     */
    @RequestMapping(value = "/analysis/chart/paymentType", method = RequestMethod.POST)
    ResultModel<Map<String, Map<String, Double>>> paymentTypeChart(AnalysisParamsDTO paramsDTO);


}

