package com.bxm.datapark.facade.venue.model.dto;

import java.io.Serializable;
import java.util.List;

/**
 * 主会场报表dto
 * @author bcc
 */
public class VenueReportDto implements Serializable {

    private String venueName;

    /**
     * 主会场ID
     */
    private String venueId;

    private List<String> venueIds;

    /**
     * 特定某一天
     */
    private String datetime;

    /**
     * 起始日期
     */
    private String startTime;

    /**
     * 结束时间
     */
    private String endTime;

    private String sortName;

    private String sortType;

    private Integer pageNum  = 1;
    /**
     * 每页数量
     */
    private Integer pageSize = 10;
    public String getVenueName() {
        return venueName;
    }

    public void setVenueName(String venueName) {
        this.venueName = venueName;
    }

    public List<String> getVenueIds() {
        return venueIds;
    }

    public void setVenueIds(List<String> venueIds) {
        this.venueIds = venueIds;
    }

    public String getDatetime() {
        return datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }


    public String getSortName() {
        return sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public String getSortType() {
        return sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String getVenueId() {
        return venueId;
    }

    public void setVenueId(String venueId) {
        this.venueId = venueId;
    }
}
