package com.bxm.datapark.facade.alarm.service;

import com.bxm.datapark.facade.Page;
import com.bxm.datapark.facade.alarm.model.AdPositionTagToday;
import com.bxm.datapark.facade.alarm.model.AdPositionTagTodayCondition;
import com.bxm.datapark.facade.alarm.model.AdTicketTagToday;
import com.bxm.datapark.facade.alarm.model.AdTicketTagTodayCondition;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

/**
 * @author sunzs
 * created on 2019/1/10
 */
@FeignClient(name = "datapark")
public interface PositionTicketWarnService {

    @RequestMapping(value = "/positionTicket/positionWarn")
    Page<AdPositionTagToday> findPositionWarnByParam(AdPositionTagTodayCondition adPositionTagTodayCondition);
    @RequestMapping("/positionTicket/excludePositionWarn")
    List<AdPositionTagToday> excludePositionWarn(AdPositionTagTodayCondition adPositionTagTodayCondition);
    @RequestMapping("/positionTicket/ticketWarn")
    Page<AdTicketTagToday> findTicketWarnByParam(AdTicketTagTodayCondition adTicketTagTodayCondition);
    @RequestMapping("/positionTicket/excludeTicketWarn")
    List<AdTicketTagToday> excludeTicketWarn(AdTicketTagTodayCondition adTicketTagTodayCondition);
}
