package com.bxm.datapark.facade.positiontest;

import org.apache.commons.lang.StringUtils;
import org.springframework.data.mongodb.core.mapping.Field;
 

public class PositionTestByTicket {

    private static final String weixin   = "微信";
    private static final String zhifubao = "支付宝";
    private static final String web      = "web";
    private static final String android  = "android";
    private static final String ios      = "ios";
    private static  final String qita="其他";

    /**
     * 编号
     */
    private String              number;
    /**
     * 礼券id
     */
    @Field("certificate_id")
    private Long                certificateId;
    /**
     * 名称
     */
    @Field("shopsname")
    private String              shopsname;
    /**
     * 礼券id
     */
    @Field("shopstype")
    private String              shopstype;
    /**
     * 入口id
     */

    @Field("positionid")
    private String              positionid;
    /**
     * 点击量
     */

    @Field("click_pv")
    private Integer             clickPv;

    /**
     * 曝光量（发券量）
     */

    @Field("open_pv")
    private Integer             openPv;

    /**
     * 有效点击量
     */

    @Field("valid_click_pv")
    private Integer             validClick;

    /**
     * 有效点击率
     */

    @Field("valid_rate")
    private Double              validClickRate;

    /**
     * 转化率/点击率
     */
    @Field("click_rate")
    private Double              conversion;

    /**
     * 发券aurp
     */
    @Field("open_pv_arpu")
    private Double              openPvArpu;

    /**
     * 点击aurp
     */
    @Field("click_pv_arpu")
    private Double              clickArpu;

    @Field("consume")
    private Double                consume;

    @Field("province")
    private String              province;

    @Field("appos")
    private String              appos;               // 操作系统（1安卓 2 ios 3web）

    @Field("payment_scene")
    private String              paymentScene;        // 支付场景 1微信 2支付宝

    public String getAppos() {
        if (StringUtils.isNotBlank(appos)) {
            if (StringUtils.equals(appos, "1")) {
                return android;
            } else if (StringUtils.equals(appos, "2")) {
                return ios;
            } else {
                return web;
            }
        } else {
            return appos;
        }

    }

    public void setAppos(String appos) {
        this.appos = appos;
    }

    public String getPaymentScene() {
        if (StringUtils.isNotBlank(paymentScene)) {
            if (StringUtils.equals(paymentScene, "1")) {
                return weixin;
            } else if(StringUtils.equals(paymentScene, "2")) {
                return zhifubao;
            }else{
                return qita;
            }
        } else {
            return paymentScene;
        }

    }

    public void setPaymentScene(String paymentScene) {
        this.paymentScene = paymentScene;
    }

    /**
     * @return the positionid
     */
    public String getPositionid() {
        return positionid;
    }

    /**
     * @param positionid the positionid to set
     */
    public void setPositionid(String positionid) {
        this.positionid = positionid;
    }

    /**
     * @return the clickPv
     */
    public Integer getClickPv() {
        return clickPv;
    }

    /**
     * @param clickPv the clickPv to set
     */
    public void setClickPv(Integer clickPv) {
        this.clickPv = clickPv;
    }

    /**
     * @return the openPv
     */
    public Integer getOpenPv() {
        return openPv;
    }

    /**
     * @param openPv the openPv to set
     */
    public void setOpenPv(Integer openPv) {
        this.openPv = openPv;
    }

    /**
     * @return the validClick
     */
    public Integer getValidClick() {
        return validClick;
    }

    /**
     * @param validClick the validClick to set
     */
    public void setValidClick(Integer validClick) {
        this.validClick = validClick;
    }

    /**
     * @return the validClickRate
     */
    public Double getValidClickRate() {
        return validClickRate;

    }

    /**
     * @param validClickRate the validClickRate to set
     */
    public void setValidClickRate(Double validClickRate) {
        this.validClickRate = validClickRate;
    }

    /**
     * @return the conversion
     */
    public Double getConversion() {
        return conversion;
    }

    /**
     * @param conversion the conversion to set
     */
    public void setConversion(Double conversion) {
        this.conversion = conversion;
    }

    /**
     * @return the openPvArpu
     */
    public Double getOpenPvArpu() {
        return openPvArpu;
    }

    /**
     * @param openPvArpu the openPvArpu to set
     */
    public void setOpenPvArpu(Double openPvArpu) {
        this.openPvArpu = openPvArpu;
    }

    /**
     * @return the clickArpu
     */
    public Double getClickArpu() {
        return clickArpu;
    }

    /**
     * @param clickArpu the clickArpu to set
     */
    public void setClickArpu(Double clickArpu) {
        this.clickArpu = clickArpu;
    }

 

    
    public Double getConsume() {
        return consume;
    }

    
    public void setConsume(Double consume) {
        this.consume = consume;
    }

    /**
     * @return the number
     */
    public String getNumber() {
        return number;
    }

    /**
     * @param number the number to set
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /**
     * @return the certificateId
     */
    public Long getCertificateId() {
        return certificateId;
    }

    /**
     * @param certificateId the certificateId to set
     */
    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    /**
     * @return the shopsname
     */
    public String getShopsname() {
        return shopsname;
    }

    /**
     * @param shopsname the shopsname to set
     */
    public void setShopsname(String shopsname) {
        this.shopsname = shopsname;
    }

    /**
     * @return the shopstype
     */
    public String getShopstype() {
        return shopstype;
    }

    /**
     * @param shopstype the shopstype to set
     */
    public void setShopstype(String shopstype) {
        this.shopstype = shopstype;
    }

    /**
     * @return the province
     */
    public String getProvince() {
        return province;
    }

    /**
     * @param province the province to set
     */
    public void setProvince(String province) {
        this.province = province;
    }

    public PositionTestByTicket(){
    }
}
