package com.bxm.egg.facade.dto;

import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;

/**
 * @author lowi
 * @date 2021/9/27 19:45
 */
@Data
@Builder
public class LocationDetailDTO implements Serializable {

    @Tolerate
    public LocationDetailDTO(){}

    /**
     * 地区编码
     */
    private String code;

    /**
     * 地区简称
     */
    private String name;

    /**
     * 是否热门城市（1表示true）
     */
    private Byte hot;

    /**
     * 城市级别（2：市、3：县（区））
     */
    private Byte level;

    /**
     * 经度
     */
    private Double lng;

    /**
     * 纬度
     */
    private Double lat;

    /**
     * 地区全称
     */
    private String fullName;

    /**
     * 最新行政编码
     */
    private String lastCode;
}
