/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.config.ClientConfigProperties;
import com.bxm.fossicker.base.service.ClientConfigService;
import com.bxm.fossicker.enums.PlatformEnum;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientConfigServiceImpl
implements ClientConfigService {
    private final ClientConfigProperties clientConfigProperties;

    @Autowired
    public ClientConfigServiceImpl(ClientConfigProperties clientConfigProperties) {
        this.clientConfigProperties = clientConfigProperties;
    }

    @Override
    public Map<String, String> getAllConfig(Integer platform) {
        Map<Object, Object> specialMap = Maps.newHashMap();
        if (platform.intValue() == PlatformEnum.ANDROID.getCode()) {
            specialMap = this.clientConfigProperties.getAndroidKeys();
        } else if (platform.intValue() == PlatformEnum.IOS.getCode()) {
            specialMap = this.clientConfigProperties.getIosKeys();
        } else if (platform.intValue() == PlatformEnum.WEB.getCode()) {
            specialMap = this.clientConfigProperties.getWebKeys();
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.putAll(this.clientConfigProperties.getCommonKeys());
        resultMap.putAll(specialMap);
        return resultMap;
    }
}

