/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl;

import com.bxm.fossicker.base.service.impl.CommonPopUpWindowsService;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpHandler;
import com.bxm.fossicker.vo.BasicParam;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class CommonPopUpWindowsServiceImpl
implements ApplicationContextAware,
ApplicationRunner,
CommonPopUpWindowsService {
    private static final Logger log = LoggerFactory.getLogger(CommonPopUpWindowsServiceImpl.class);
    public static final Map<Class, PopUpHandler> POP_UP_HANDLER_HASH_MAP = Maps.newHashMap();
    private ApplicationContext applicationContext;

    @Override
    public <R> R handle(BasicParam param) {
        PopUpHandler handler = POP_UP_HANDLER_HASH_MAP.get(param.getClass());
        if (Objects.isNull(handler)) {
            log.warn("\u7c7b\u578b: {} \u6ca1\u6709\u5bf9\u5e94\u7684handler\u5904\u7406\u7c7b", param.getClass());
            return (R)Lists.newArrayList();
        }
        return handler.handle(param);
    }

    public void run(ApplicationArguments args) throws Exception {
        Collection popUpHandlers = this.applicationContext.getBeansOfType(PopUpHandler.class).values();
        popUpHandlers.forEach(p -> POP_UP_HANDLER_HASH_MAP.put(p.support(), (PopUpHandler)p));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

