/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.fossicker.base.constant.BaseRedisKey;
import com.bxm.fossicker.base.domain.CommonEquipmentAppMapper;
import com.bxm.fossicker.base.domain.EquipmentExtMapper;
import com.bxm.fossicker.base.domain.EquipmentMapper;
import com.bxm.fossicker.base.dto.EquipmentInfoDto;
import com.bxm.fossicker.base.enums.EquipmentEnum;
import com.bxm.fossicker.base.facade.model.EquipmentDTO;
import com.bxm.fossicker.base.param.AppInfoParam;
import com.bxm.fossicker.base.param.EquipmentBaseInfo;
import com.bxm.fossicker.base.param.EquipmentParam;
import com.bxm.fossicker.base.service.EquipmentService;
import com.bxm.fossicker.base.utils.EquipmentValidator;
import com.bxm.fossicker.base.vo.CommonEquipmentApp;
import com.bxm.fossicker.base.vo.EquipmentExtInfo;
import com.bxm.fossicker.base.vo.EquipmentInfo;
import com.bxm.fossicker.constant.UserRedisKeyConstant;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.vo.BasicParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.MD5Util;
import com.bxm.newidea.component.tools.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryException;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class EquipmentServiceImpl
extends BaseService
implements EquipmentService {
    private final EquipmentExtMapper equipmentExtMapper;
    private final EquipmentMapper equipmentMapper;
    private final UserInfoFacadeService userInfoFacadeService;
    private final RedisHashMapAdapter redisHashMapAdapter;
    private final DistributedLock distributedLock;
    private final CommonEquipmentAppMapper commonEquipmentAppMapper;
    private static final String DEFAULT_BLOCK_DEVID = "0";

    @Autowired
    public EquipmentServiceImpl(EquipmentExtMapper equipmentExtMapper, EquipmentMapper equipmentMapper, UserInfoFacadeService userInfoFacadeService, RedisHashMapAdapter redisHashMapAdapter, DistributedLock distributedLock, CommonEquipmentAppMapper commonEquipmentAppMapper) {
        this.equipmentExtMapper = equipmentExtMapper;
        this.equipmentMapper = equipmentMapper;
        this.userInfoFacadeService = userInfoFacadeService;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.distributedLock = distributedLock;
        this.commonEquipmentAppMapper = commonEquipmentAppMapper;
    }

    @Override
    @Retryable(backoff=@Backoff(value=200L), value={RetryException.class})
    public EquipmentInfoDto createMutedUser(EquipmentParam equipmentParam) {
        Long userId;
        String requestId = this.nextSequence().toString();
        String key = equipmentParam.hashCode() + "";
        if (!this.distributedLock.lock(key, requestId)) {
            this.logger.error("\u521b\u5efa\u8bbe\u5907\u4fe1\u606f\u5b58\u5728\u91cd\u590d\u8bf7\u6c42:[{}]", (Object)equipmentParam);
            throw new RetryException("\u521b\u5efa\u8bbe\u5907\u4fe1\u606f\u5b58\u5728\u91cd\u590d\u8bf7\u6c42");
        }
        String id = equipmentParam.getDevcId();
        boolean existsEquipment = false;
        if (StringUtils.isNotBlank((CharSequence)id) && NumberUtils.isDigits((String)id) && !DEFAULT_BLOCK_DEVID.equals(id)) {
            EquipmentDTO equipmentDTO = this.get(id);
            if (null != equipmentDTO) {
                this.createOrUpdate(equipmentParam, true, equipmentDTO);
                existsEquipment = true;
            } else {
                this.logger.error("\u8bf7\u6c42\u63d0\u4f9b\u4e86\u8bbe\u5907\u4fe1\u606fID\uff0c\u4f46\u662f\u6570\u636e\u5e93\u4e2d\u5e76\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5386\u53f2\u8bb0\u5f55");
            }
        }
        if (!existsEquipment) {
            List<String> extractInfos = this.extractEquipment(equipmentParam);
            if (CollectionUtils.isEmpty(extractInfos)) {
                this.logger.error("\u53c2\u6570\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55\u8bbe\u5907\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)equipmentParam);
                return new EquipmentInfoDto(Long.valueOf(0L), DEFAULT_BLOCK_DEVID);
            }
            Long historyEquimentId = this.equipmentExtMapper.selectByIdentifiers(extractInfos);
            if (null != historyEquimentId) {
                id = String.valueOf(historyEquimentId);
                equipmentParam.setDevcId(id);
                this.createOrUpdate(equipmentParam, true, null);
            } else {
                id = this.nextSequence().toString();
                equipmentParam.setDevcId(id);
                this.createOrUpdate(equipmentParam, false, null);
            }
        }
        if (Objects.isNull(equipmentParam.getUserId())) {
            userId = this.userInfoFacadeService.createMutedUser(Long.valueOf(id), (BasicParam)equipmentParam);
            if (this.isBetterVersion((BasicParam)equipmentParam)) {
                this.logger.info("\u7528\u6237\u91cd\u65b0\u767b\u5f55\uff0c\u6ce8\u9500token\uff0c\u76f8\u5173\u53c2\u6570\uff1a{}", (Object)equipmentParam);
                this.redisHashMapAdapter.remove(UserRedisKeyConstant.HASH_USER_TOKEN, new String[]{Objects.toString(userId)});
            }
        } else {
            userId = equipmentParam.getUserId();
        }
        EquipmentInfoDto result = new EquipmentInfoDto();
        result.setEquipmentId(id);
        result.setUserId(userId);
        this.distributedLock.unlock(key, requestId);
        this.logger.debug("\u8bbe\u5907\u4e0a\u62a5\u63a5\u53e3,\u8bbe\u5907\u4e0e\u9759\u9ed8\u7528\u6237\u4fe1\u606f:[{}]", (Object)result);
        return result;
    }

    private boolean isBetterVersion(BasicParam param) {
        return null != param && null != param.getCurVer() && StringUtils.compareVersion((String)param.getCurVer(), (String)"1.4.0") >= 0;
    }

    private List<String> extractEquipment(EquipmentParam equipmentParam) {
        return new ArrayList<String>(this.getEquipmentMap((EquipmentBaseInfo)equipmentParam).values());
    }

    private Map<String, String> getEquipmentMap(EquipmentBaseInfo equipmentParam) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{equipmentParam.getImei()})) {
            map.put(EquipmentEnum.ANDROID_IMEI.name(), equipmentParam.getImei());
            map.put(EquipmentEnum.ANDROID_IMEI_MD5.name(), MD5Util.hgmd5((String)equipmentParam.getImei()));
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getImeiMd5())) {
            map.put(EquipmentEnum.ANDROID_IMEI_MD5.name(), equipmentParam.getImeiMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getAndroidId())) {
            map.put(EquipmentEnum.ANDROID_ID.name(), equipmentParam.getAndroidId());
            map.put(EquipmentEnum.ANDROID_ID_MD5.name(), MD5Util.hgmd5((String)equipmentParam.getAndroidId()));
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getAndroidIdMd5())) {
            map.put(EquipmentEnum.ANDROID_ID_MD5.name(), equipmentParam.getAndroidIdMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getAndroidUuid())) {
            map.put(EquipmentEnum.ANDROID_UUID.name(), equipmentParam.getAndroidUuid());
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getIdfa()) && EquipmentValidator.idfa(equipmentParam.getIdfa())) {
            map.put(EquipmentEnum.IOS_IDFA.name(), equipmentParam.getIdfa());
            map.put(EquipmentEnum.IOS_IDFA_MD5.name(), MD5Util.hgmd5((String)equipmentParam.getIdfa()));
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getIdfaMd5())) {
            map.put(EquipmentEnum.IOS_IDFA_MD5.name(), equipmentParam.getIdfaMd5());
        }
        if (StringUtils.isNotBlank((CharSequence)equipmentParam.getIosId())) {
            map.put(EquipmentEnum.IOS_DEVICE_ID.name(), equipmentParam.getIosId());
        }
        return map;
    }

    private void createOrUpdate(EquipmentParam equipmentParam, boolean hasHistory, EquipmentDTO existsEquipment) {
        Date now = new Date();
        ArrayList<EquipmentExtInfo> equipmentExtInfoList = new ArrayList<EquipmentExtInfo>();
        this.getEquipmentMap((EquipmentBaseInfo)equipmentParam).forEach((k, v) -> {
            EquipmentExtInfo equipmentExtInfo = EquipmentExtInfo.builder().createTime(now).modifyTime(now).id(Long.valueOf(equipmentParam.getDevcId())).identifierName(k).identifierValue(v).build();
            equipmentExtInfoList.add(equipmentExtInfo);
        });
        EquipmentInfo equipmentInfo = new EquipmentInfo();
        org.springframework.beans.BeanUtils.copyProperties((Object)equipmentParam, (Object)equipmentInfo);
        equipmentInfo.setEnableNotification(Boolean.valueOf(equipmentParam.isEnableNotification()));
        equipmentInfo.setId(Long.valueOf(equipmentParam.getDevcId()));
        equipmentInfo.setModifyTime(now);
        equipmentInfo.setCurrentVersion(equipmentParam.getCurVer());
        List<Object> commonEquipmentAppList = new ArrayList<CommonEquipmentApp>();
        if (StringUtils.isNotEmpty((CharSequence)equipmentParam.getAppInfoParamList())) {
            List appInfoParamList = JSONObject.parseArray((String)equipmentParam.getAppInfoParamList(), AppInfoParam.class);
            commonEquipmentAppList = appInfoParamList.stream().map(e -> {
                CommonEquipmentApp commonEquipmentApp = new CommonEquipmentApp();
                commonEquipmentApp.setAppName(e.getAppName());
                commonEquipmentApp.setPackageName(e.getPackageName());
                commonEquipmentApp.setId(Long.valueOf(equipmentParam.getDevcId()));
                commonEquipmentApp.setModifyTime(new Date());
                commonEquipmentApp.setCreateTime(new Date());
                return commonEquipmentApp;
            }).collect(Collectors.toList());
        }
        if (hasHistory) {
            this.compareAndModify(existsEquipment, equipmentInfo, equipmentExtInfoList, commonEquipmentAppList);
        } else {
            equipmentInfo.setCreateTime(now);
            this.equipmentMapper.insert(equipmentInfo);
            MybatisBatchBuilder.create(EquipmentExtMapper.class, equipmentExtInfoList).run(EquipmentExtMapper::insert);
            MybatisBatchBuilder.create(CommonEquipmentAppMapper.class, commonEquipmentAppList).run(CommonEquipmentAppMapper::insert);
            this.cleanCache(equipmentInfo.getId());
        }
    }

    private void cleanCache(Long equipmentId) {
        this.redisHashMapAdapter.remove(this.buildKey(equipmentId), new String[]{String.valueOf(equipmentId)});
    }

    private void compareAndModify(EquipmentDTO existsEquipment, EquipmentInfo equipmentInfo, List<EquipmentExtInfo> equipmentExtInfoList, List<CommonEquipmentApp> commonEquipmentAppList) {
        List<EquipmentExtInfo> existsExtInfos;
        if (null == existsEquipment) {
            existsEquipment = this.get(String.valueOf(equipmentInfo.getId()));
        }
        boolean hit = false;
        EquipmentInfo existsInfo = this.parseInfo(existsEquipment);
        if (!equipmentInfo.equals((Object)existsInfo)) {
            this.equipmentMapper.updateByPrimaryKey(equipmentInfo);
            hit = true;
            this.logger.debug("\u8bbe\u5907\u57fa\u7840\u4fe1\u606f\u53d8\u66f4\uff1a{}", (Object)equipmentInfo);
        }
        if (this.isNotEquals(existsExtInfos = this.parseExtInfo(existsEquipment), equipmentExtInfoList)) {
            this.equipmentExtMapper.delete(equipmentInfo.getId());
            MybatisBatchBuilder.create(EquipmentExtMapper.class, equipmentExtInfoList).run(EquipmentExtMapper::insert);
            hit = true;
            this.logger.debug("\u8bbe\u5907\u6807\u8bc6\u4fe1\u606f\u53d8\u66f4\uff1a{},\u552f\u4e00\u6807\u8bc6\uff1a{}", (Object)equipmentInfo, equipmentExtInfoList);
        }
        if (this.isNotEquals(existsEquipment.getApps(), commonEquipmentAppList)) {
            this.commonEquipmentAppMapper.delete(equipmentInfo.getId());
            MybatisBatchBuilder.create(CommonEquipmentAppMapper.class, commonEquipmentAppList).run(CommonEquipmentAppMapper::insert);
            hit = true;
            this.logger.debug("\u8bbe\u5907\u5b89\u88c5\u4fe1\u606f\u5217\u8868\u53d8\u66f4\uff1a{}", (Object)equipmentInfo);
        }
        if (hit) {
            this.cleanCache(equipmentInfo.getId());
        } else {
            this.logger.debug("\u8bbe\u5907[{}]\u4fe1\u606f\u672a\u53d8\u66f4\uff0c\u4e0d\u505a\u66f4\u65b0\u5904\u7406", (Object)equipmentInfo.getId());
        }
    }

    private boolean isNotEquals(List source, List target) {
        if (null == source && null == target) {
            return false;
        }
        if (null == source || null == target) {
            return true;
        }
        return !CollectionUtils.isEqualCollection((Collection)source, (Collection)target);
    }

    private EquipmentInfo parseInfo(EquipmentDTO existsEquipment) {
        return EquipmentInfo.builder().id(Long.valueOf(existsEquipment.getId())).currentVersion(existsEquipment.getCurVer()).operatingSystem(existsEquipment.getOperatingSystem()).enableNotification(Boolean.valueOf(existsEquipment.isEnableNotification())).phoneModel(existsEquipment.getPhoneModel()).build();
    }

    private List<EquipmentExtInfo> parseExtInfo(EquipmentDTO existsEquipment) {
        ArrayList<EquipmentExtInfo> equipmentExtInfoList = new ArrayList<EquipmentExtInfo>();
        this.getEquipmentMap((EquipmentBaseInfo)existsEquipment).forEach((k, v) -> {
            EquipmentExtInfo equipmentExtInfo = EquipmentExtInfo.builder().identifierName(k).identifierValue(v).build();
            equipmentExtInfoList.add(equipmentExtInfo);
        });
        return equipmentExtInfoList;
    }

    private KeyGenerator buildKey(Long id) {
        return BaseRedisKey.EQUIPMENT_HASH.copy().appendKey((Object)(id % 20L));
    }

    @Override
    public EquipmentDTO get(String equipmentId) {
        if (DEFAULT_BLOCK_DEVID.equals(equipmentId) || !NumberUtils.isDigits((String)equipmentId)) {
            this.logger.error("\u975e\u6cd5\u7684\u8bbe\u5907\u53f7\uff1a{}", (Object)equipmentId);
            return null;
        }
        Long id = Long.valueOf(equipmentId);
        KeyGenerator key = this.buildKey(id);
        EquipmentDTO equipmentDTO = (EquipmentDTO)this.redisHashMapAdapter.get(key, equipmentId, EquipmentDTO.class);
        if (null == equipmentDTO) {
            equipmentDTO = new EquipmentDTO();
            List equipmentExtInfoList = this.equipmentExtMapper.selectByPrimaryKey(id);
            if (CollectionUtils.isNotEmpty((Collection)equipmentExtInfoList)) {
                HashMap map = new HashMap(3);
                equipmentExtInfoList.forEach(e -> map.put(EquipmentEnum.valueOf(e.getIdentifierName()).getType(), e.getIdentifierValue()));
                try {
                    BeanUtils.populate((Object)equipmentDTO, map);
                    equipmentDTO.setId(equipmentId);
                }
                catch (IllegalAccessException | InvocationTargetException e2) {
                    this.logger.error(e2.getMessage(), (Throwable)e2);
                }
            }
            equipmentDTO.setApps(this.commonEquipmentAppMapper.getEquipmentApps(id));
            this.redisHashMapAdapter.put(key, equipmentId, (Object)equipmentDTO);
        }
        if (equipmentDTO.getId() == null) {
            equipmentDTO = null;
        }
        return equipmentDTO;
    }

    @Override
    public boolean checkHasOpenPush(String deviceId) {
        if (!NumberUtils.isDigits((String)deviceId)) {
            this.logger.error("\u8bf7\u6c42\u8bbe\u5907ID\u4e0d\u662f\u4e00\u4e2a\u6570\u5b57\uff0c\u975e\u6cd5\u8bf7\u6c42\uff1a{}", (Object)deviceId);
            return false;
        }
        EquipmentInfo equipmentInfo = this.equipmentMapper.selectByPrimaryKey(Long.valueOf(deviceId));
        return null != equipmentInfo && equipmentInfo.getEnableNotification() != false;
    }
}

