/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.constant.PopUpRedisConstant;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import java.util.Date;
import java.util.Objects;

@PopUpProcess(order=PopUpProcessOrderEn.RECORD_TIMES)
public class TimesRecodePopUpWindowsInterceptor
extends AbstractPopUpWindowsInterceptor {
    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        popUpWindows.getPopUpWindows().stream().forEach(p -> {
            if (Objects.nonNull(p.getCategory()) && Objects.equals(p.getCategory().intValue(), 3)) {
                this.redisHashMapAdapter.increment(PopUpRedisConstant.VIEWED_COUNT_POPUP_CACHE.copy(), Objects.toString(p.getId()), 1);
                UserPopUpedBO popUpedBO = (UserPopUpedBO)popUpWindows.getPopUpedInfo().get(Objects.toString(p.getId()));
                if (Objects.nonNull(popUpedBO)) {
                    int times = Objects.isNull(popUpedBO.getTimes()) ? 0 : popUpedBO.getTimes();
                    switch (p.getFrequencyType()) {
                        case 1: {
                            popUpedBO.setTimes(Integer.valueOf(times + 1));
                            break;
                        }
                        case 2: {
                            popUpedBO.setTimes(Integer.valueOf(times + 1));
                            popUpedBO.setDay(new Date());
                        }
                    }
                } else {
                    popUpedBO = new UserPopUpedBO();
                    popUpedBO.setDay(new Date());
                    popUpedBO.setFinalClose(Boolean.FALSE);
                    popUpedBO.setPopUpId(p.getId());
                    popUpedBO.setType(p.getType());
                    popUpedBO.setCategory(p.getCategory());
                    popUpedBO.setTimes(Integer.valueOf(1));
                    popUpWindows.getPopUpedInfo().put(Objects.toString(popUpedBO.getPopUpId()), popUpedBO);
                }
            }
        });
    }
}

