/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.interceptor;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.order.facade.service.OrderFacadeService;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.enums.VipTypeEnum;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess
public class UserTypePopUpWindowsInterceptor
extends AbstractPopUpWindowsInterceptor {
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;
    @Autowired
    private OrderFacadeService orderFacadeService;
    @Autowired
    private VipFacadeService vipFacadeService;

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = popUpWindows.getPopUpWindows();
        List removeList = commonPopUpWindowsEntryList.stream().filter(p -> {
            if (Objects.isNull(p.getUserType())) {
                return true;
            }
            if (p.getUserType().intValue() == 0) {
                return false;
            }
            if (Objects.isNull(popUpWindows.getParam().getUserId())) {
                return true;
            }
            switch (p.getUserType()) {
                case 1: {
                    return this.userInfoFacadeService.isNoviceUser(popUpWindows.getParam().getUserId()) == false;
                }
                case 2: {
                    return this.userInfoFacadeService.isNoviceUser(popUpWindows.getParam().getUserId());
                }
                case 3: {
                    return this.orderFacadeService.hasOrdered(popUpWindows.getParam().getUserId());
                }
                case 4: {
                    return this.orderFacadeService.hasOrdered(popUpWindows.getParam().getUserId()) == false;
                }
                case 5: {
                    List userIds = JSON.parseArray((String)p.getUserIds(), Long.class);
                    if (!CollectionUtils.isEmpty((Collection)userIds)) {
                        return !userIds.contains(popUpWindows.getParam().getUserId());
                    }
                    return true;
                }
                case 6: {
                    Byte vipStatus = this.vipFacadeService.getVipStatus(popUpWindows.getParam().getUserId());
                    return Objects.equals(vipStatus, (byte)VipTypeEnum.VIP_FOREVER.getType());
                }
                case 7: {
                    return this.vipFacadeService.isVip(popUpWindows.getParam().getUserId());
                }
                case 8: {
                    return !this.vipFacadeService.isVip(popUpWindows.getParam().getUserId());
                }
            }
            return true;
        }).peek(p -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u7528\u6237\u7c7b\u578b\u8fc7\u6ee4\u5668\uff0c\u8fc7\u6ee4\u5f39\u7a97: {}", (Object)p.getName());
            }
        }).collect(Collectors.toList());
        commonPopUpWindowsEntryList.removeAll(removeList);
    }
}

