/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.constant.PopUpRedisConstant;
import com.bxm.fossicker.base.domain.CommonPopUpWindowsMapper;
import com.bxm.fossicker.base.entity.CommonPopUpWindows;
import com.bxm.fossicker.base.entity.CommonPopUpWindowsEntry;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.AbstractPopUpWindowsInterceptor;
import com.bxm.fossicker.base.service.impl.popup.interfacies.ClosePopUp;
import com.bxm.fossicker.base.service.impl.popup.interfacies.PopUpWindowsProcess;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractPopUpWindowsProcess
extends AbstractPopUpWindowsInterceptor
implements ClosePopUp,
PopUpWindowsProcess {
    @Autowired
    protected RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    protected CommonPopUpWindowsMapper commonPopUpWindowsMapper;
    protected PopUpEnum currentSupportPopUpKey;
    protected static final String CURRENT_PROCESS_SUPPORT_POP_UP_KEY = "CURRENT_PROCESS_SUPPORT_POP_UP_KEY";

    @Override
    protected void doInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (this.preInvoke(popUpWindows)) {
            this.postInvoke(popUpWindows);
            this.afterCompletion(popUpWindows);
        }
    }

    @Override
    public void close(PopUpWindowsCloseParam param) {
        this.doClose(param);
    }

    @Override
    public void setProcessSupportPopUp(PopUpEnum popUp) {
        this.currentSupportPopUpKey = popUp;
    }

    private boolean didHaveCurrentProcessSupportPopUp(FilterPopUpWindowsBO popUpWindows, PopUpEnum popUp) {
        List<CommonPopUpWindowsEntry> currentSupport;
        if (!CollectionUtils.isEmpty((Collection)popUpWindows.getPopUpWindows()) && Objects.nonNull(popUp) && !CollectionUtils.isEmpty(currentSupport = this.getByType(popUpWindows.getPopUpWindows(), popUp))) {
            popUpWindows.getParams().put(CURRENT_PROCESS_SUPPORT_POP_UP_KEY, currentSupport);
            return true;
        }
        return false;
    }

    private List<CommonPopUpWindowsEntry> getByType(List<CommonPopUpWindowsEntry> popUpWindows, PopUpEnum popUp) {
        if (!CollectionUtils.isEmpty(popUpWindows)) {
            return popUpWindows.stream().filter(p -> Objects.equals(p.getType(), popUp.getType())).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    protected void closeAndIncrementTimes(Long popUpId, String unique) {
        KeyGenerator key = PopUpRedisConstant.USER_POPUP_CACHE.copy().appendKey((Object)unique);
        UserPopUpedBO userPopUpedBO = (UserPopUpedBO)this.redisHashMapAdapter.get(key, Objects.toString(popUpId), UserPopUpedBO.class);
        CommonPopUpWindows commonPopUpWindows = this.commonPopUpWindowsMapper.selectByPrimaryKey(popUpId);
        if (Objects.isNull(userPopUpedBO) && Objects.nonNull(commonPopUpWindows)) {
            userPopUpedBO = new UserPopUpedBO();
            userPopUpedBO.setDay(new Date());
            userPopUpedBO.setTimes(Integer.valueOf(0));
            userPopUpedBO.setPopUpId(popUpId);
            userPopUpedBO.setType(commonPopUpWindows.getType());
            userPopUpedBO.setCategory(commonPopUpWindows.getCategory());
            userPopUpedBO.setFinalClose(Boolean.FALSE);
        } else {
            userPopUpedBO.setDay(new Date());
        }
        userPopUpedBO.setTimes(Integer.valueOf(Objects.isNull(userPopUpedBO.getTimes()) ? 1 : userPopUpedBO.getTimes() + 1));
        this.redisHashMapAdapter.put(key, Objects.toString(popUpId), (Object)userPopUpedBO);
    }

    protected Long getPopId(PopUpWindowsCloseParam param) {
        Long popId = Objects.nonNull(param.getPopUpId()) ? param.getPopUpId() : this.getPopIdByType(param.getType());
        return popId;
    }

    protected Long getPopIdByType(Byte type) {
        List commonPopUpWindows = this.commonPopUpWindowsMapper.selectByType((int)type.byteValue());
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindows)) {
            return ((CommonPopUpWindows)commonPopUpWindows.get(0)).getId();
        }
        return null;
    }

    protected void remove(FilterPopUpWindowsBO popUpWindows, PopUpEnum popUp) {
        if (!CollectionUtils.isEmpty((Collection)popUpWindows.getPopUpWindows()) && !Objects.isNull(popUp)) {
            popUpWindows.getPopUpWindows().removeIf(p -> Objects.equals(p.getType(), popUp.getType()));
        }
        popUpWindows.getParams().remove(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);
    }

    protected void removeCurrent(FilterPopUpWindowsBO popUpWindows) {
        this.remove(popUpWindows, this.currentSupportPopUpKey);
    }

    protected void autoClose(FilterPopUpWindowsBO popUpWindows, Boolean finalClose, int times) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam(CURRENT_PROCESS_SUPPORT_POP_UP_KEY);
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                String key = Objects.toString(p.getId());
                UserPopUpedBO userPopUpedBO = (UserPopUpedBO)popUpWindows.getPopUpedInfo().get(key);
                if (Objects.isNull(userPopUpedBO)) {
                    userPopUpedBO = new UserPopUpedBO();
                    userPopUpedBO.setDay(new Date());
                    userPopUpedBO.setTimes(Integer.valueOf(0));
                    userPopUpedBO.setPopUpId(p.getId());
                    userPopUpedBO.setType(p.getType());
                    userPopUpedBO.setCategory(p.getCategory());
                    userPopUpedBO.setFinalClose(finalClose);
                    popUpWindows.getPopUpedInfo().put(key, userPopUpedBO);
                } else {
                    userPopUpedBO.setDay(new Date());
                }
                userPopUpedBO.setTimes(Integer.valueOf(Objects.isNull(userPopUpedBO.getTimes()) ? times : userPopUpedBO.getTimes() + times));
            });
        }
    }

    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (Objects.isNull(this.currentSupportPopUpKey)) {
            this.log.warn("\u5f53\u524d\u5904\u7406\u7c7b: {} \u6ca1\u6709\u8bbe\u7f6e\u597d\u652f\u6301\u7684\u5f39\u7a97\u7c7b\u578b", this.getClass());
            return false;
        }
        return this.didHaveCurrentProcessSupportPopUp(popUpWindows, this.currentSupportPopUpKey);
    }

    protected abstract void postInvoke(FilterPopUpWindowsBO var1);

    protected abstract void doClose(PopUpWindowsCloseParam var1);

    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
    }
}

