/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.config.PopUpProperties;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.enums.UserJudgeMarkerEnum;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.fossicker.user.facade.dto.UserInfoDto;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.GOLD_RATE_CHANGE, order=PopUpProcessOrderEn.CUSTOM)
public class GoldRateChangeWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Resource
    private PopUpProperties popUpProperties;
    @Resource
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        UserInfoDto user = this.userInfoFacadeService.getUserById(popUpWindows.getParam().getUserId());
        if (Objects.isNull(user) || Objects.nonNull(user.getJudgeMarker()) && BitOperatorUtil.getBitAsBoolean((Long)user.getJudgeMarker(), (int)UserJudgeMarkerEnum.SET_SPECIAL.getIndex())) {
            this.autoClose(popUpWindows, Boolean.TRUE, 1);
            this.removeCurrent(popUpWindows);
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u7528\u6237: {} \u662f\u65b0\u7248\u672c\u7528\u6237\uff0c\u4e0d\u8fd4\u56de\u5151\u6362\u6bd4\u4f8b\u5f39\u7a97", (Object)popUpWindows.getParam().getUserId());
            }
        }
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                HashMap note = Maps.newHashMap();
                note.put("note", this.popUpProperties.getGoldChangeText());
                p.setExt(JSON.toJSONString((Object)note));
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u9996\u9875\u300a\u91d1\u5e01\u5151\u6362\u6bd4\u4f8b\u8c03\u6574\u5f39\u7a97\u300b\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

