/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.homepage;

import com.alibaba.fastjson.JSON;
import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.model.LoginRewardFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.HOME_LOGIN_REWARD, order=PopUpProcessOrderEn.CUSTOM)
public class LoginRewardWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private ActivityFacadeService activityFacadeService;
    private static final String LOGIN_REWARD_FACADE_DTO = "LOGIN_REWARD_FACADE_DTO";

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        LoginRewardFacadeDTO facadeDTO = this.activityFacadeService.loginRewardInfo(popUpWindows.getParam().getUserId());
        if (Objects.isNull(facadeDTO) || facadeDTO.getGot().booleanValue()) {
            this.remove(popUpWindows, PopUpEnum.HOME_LOGIN_REWARD);
        } else {
            popUpWindows.getParams().put(LOGIN_REWARD_FACADE_DTO, facadeDTO);
        }
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.forEach(p -> {
                LoginRewardFacadeDTO facadeDTO = (LoginRewardFacadeDTO)popUpWindows.getParam(LOGIN_REWARD_FACADE_DTO);
                LoginRewardWindowsExt ext = new LoginRewardWindowsExt();
                ext.setReward(facadeDTO.getReward());
                p.setExt(JSON.toJSONString((Object)ext));
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u9996\u9875\u767b\u5f55\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }

    public class LoginRewardWindowsExt {
        private BigDecimal reward;

        public BigDecimal getReward() {
            return this.reward;
        }

        public void setReward(BigDecimal reward) {
            this.reward = reward;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginRewardWindowsExt)) {
                return false;
            }
            LoginRewardWindowsExt other = (LoginRewardWindowsExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$reward = this.getReward();
            BigDecimal other$reward = other.getReward();
            return !(this$reward == null ? other$reward != null : !((Object)this$reward).equals(other$reward));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LoginRewardWindowsExt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $reward = this.getReward();
            result = result * 59 + ($reward == null ? 43 : ((Object)$reward).hashCode());
            return result;
        }

        public String toString() {
            return "LoginRewardWindowsProcess.LoginRewardWindowsExt(reward=" + this.getReward() + ")";
        }
    }
}

