/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.mine;

import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.model.TreasureBoxFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

@PopUpProcess(special=PopUpEnum.MINE_TREASURE_BOX, order=PopUpProcessOrderEn.CUSTOM)
public class TreasureBoxWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private ActivityFacadeService activityFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        TreasureBoxFacadeDTO treasureBoxFacadeDTO = this.activityFacadeService.treasureBox(popUpWindows.getParam().getUserId());
        if (Objects.isNull(treasureBoxFacadeDTO) && Objects.equals(treasureBoxFacadeDTO.getStatus(), 0)) {
            return;
        }
        this.remove(popUpWindows, PopUpEnum.TASK_TAOBAO_SEARCH);
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u5b9d\u7bb1\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

