/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.commodity.facade.CommodityFacadeService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.TASK_FIRST_BROWSE, order=PopUpProcessOrderEn.CUSTOM)
public class FirstBrowseWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private TaskFacadeService taskFacadeService;
    @Autowired
    private CommodityFacadeService commodityFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        ActivityUserTaskFacadeDTO activityUserTaskFacadeDTO = this.taskFacadeService.queryUserTask(popUpWindows.getParam().getUserId(), ActivityFacadeEnum.VIEW_GOODS);
        if (Objects.nonNull(activityUserTaskFacadeDTO) && activityUserTaskFacadeDTO.getStatus() == 0) {
            Long popId = this.getPopIdByType(PopUpEnum.TASK_TAOBAO_AUTH.getType());
            UserPopUpedBO userPopUpedBO = (UserPopUpedBO)popUpWindows.getPopUpedInfo().get(Objects.toString(popId));
            if (Objects.nonNull(userPopUpedBO) && Objects.nonNull(userPopUpedBO.getFinalClose()) && userPopUpedBO.getFinalClose().booleanValue() && (Objects.nonNull(userPopUpedBO.getDay()) && !DateUtils.isSameDay((Date)userPopUpedBO.getDay(), (Date)new Date()) || Objects.nonNull(userPopUpedBO.getDay()) && DateUtils.isSameDay((Date)userPopUpedBO.getDay(), (Date)new Date()) && Objects.nonNull(userPopUpedBO.getTimes()) && userPopUpedBO.getTimes() == 0)) {
                return;
            }
            this.remove(popUpWindows, PopUpEnum.TASK_FIRST_BROWSE);
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u9996\u6b21\u6d4f\u89c8\u5546\u54c1\u8fc7\u6ee4\u5668\uff0c\u8fc7\u6ee4\u9996\u6b21\u6d4f\u89c8\u5546\u54c1\u5f39\u7a97");
            }
        }
        this.autoClose(popUpWindows, Boolean.TRUE, 0);
        this.remove(popUpWindows, PopUpEnum.TASK_FIRST_BROWSE);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            Long commodityId = this.commodityFacadeService.getWellChoseFirstCommodityId(popUpWindows.getParam().getUserId());
            String jumpUrl = "qtj://goods/goodsDetail?goodsId=";
            if (Objects.nonNull(commodityId)) {
                jumpUrl = StringUtils.join((Object[])new Serializable[]{jumpUrl, commodityId});
            }
            String fJump = jumpUrl;
            commonPopUpWindowsEntryList.stream().forEach(p -> {
                p.setExt(p.getMaterialExt());
                p.setJumpUrl(fJump);
            });
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u65b0\u4eba\u6559\u7a0b\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

