/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.task;

import com.bxm.fossicker.activity.facade.TaskFacadeService;
import com.bxm.fossicker.activity.facade.enums.ActivityFacadeEnum;
import com.bxm.fossicker.activity.facade.model.ActivityUserTaskFacadeDTO;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.bo.UserPopUpedBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.user.facade.UserInfoFacadeService;
import com.bxm.newidea.component.tools.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.TASK_TAOBAO_SEARCH, order=PopUpProcessOrderEn.CUSTOM)
public class TaobaoSearchWindowsProcess
extends AbstractPopUpWindowsProcess {
    @Autowired
    private TaskFacadeService taskFacadeService;
    @Autowired
    private UserInfoFacadeService userInfoFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        ActivityUserTaskFacadeDTO activityUserTaskFacadeDTO = this.taskFacadeService.queryUserTask(popUpWindows.getParam().getUserId(), ActivityFacadeEnum.SEARCH_TITLE);
        if (Objects.nonNull(activityUserTaskFacadeDTO) && activityUserTaskFacadeDTO.getStatus() == 0) {
            Long popId = this.getPopIdByType(PopUpEnum.TASK_FIRST_BROWSE.getType());
            UserPopUpedBO userPopUpedBO = (UserPopUpedBO)popUpWindows.getPopUpedInfo().get(Objects.toString(popId));
            if (Objects.nonNull(userPopUpedBO) && Objects.nonNull(userPopUpedBO.getFinalClose()) && userPopUpedBO.getFinalClose().booleanValue() && (Objects.nonNull(userPopUpedBO.getDay()) && !DateUtils.isSameDay((Date)userPopUpedBO.getDay(), (Date)new Date()) || Objects.nonNull(userPopUpedBO.getDay()) && DateUtils.isSameDay((Date)userPopUpedBO.getDay(), (Date)new Date()) && Objects.nonNull(userPopUpedBO.getTimes()) && userPopUpedBO.getTimes() == 0)) {
                return;
            }
            this.remove(popUpWindows, PopUpEnum.TASK_TAOBAO_SEARCH);
            if (this.log.isDebugEnabled()) {
                this.log.debug("\u641c\u7d22\u6dd8\u5b9d\u6807\u9898\u8fc7\u6ee4\u5668\uff0c\u8fc7\u6ee4\u641c\u7d22\u6dd8\u5b9d\u6807\u9898\u5f39\u7a97");
            }
        }
        this.autoClose(popUpWindows, Boolean.TRUE, 0);
        this.remove(popUpWindows, PopUpEnum.TASK_TAOBAO_SEARCH);
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> p.setExt(p.getMaterialExt()));
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
        Long popId = this.getPopId(param);
        if (Objects.isNull(popId)) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u5f39\u7a97id\uff0c\u65e0\u6cd5\u8bb0\u5f55\u641c\u7d22\u6dd8\u5b9d\u6807\u9898\u5f39\u7a97\u5f39\u51fa, type: {}, popIp: {}", (Object)param.getType(), (Object)param.getPopUpId());
            return;
        }
        this.closeAndIncrementTimes(popId, Objects.toString(param.getUserId()));
    }
}

