/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.vipPage;

import com.alibaba.fastjson.JSONObject;
import com.bxm.fossicker.activity.facade.ActivityFacadeService;
import com.bxm.fossicker.activity.facade.InviteRelationFacadeService;
import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.user.facade.dto.TobeVipInviteSpeedDto;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.TOBE_VIP_INVITE_SPEED, order=PopUpProcessOrderEn.CUSTOM)
public class TobeVipForInvitePopWindowsProcess
extends AbstractPopUpWindowsProcess {
    private static final Logger log = LoggerFactory.getLogger(TobeVipForInvitePopWindowsProcess.class);
    @Autowired
    private InviteRelationFacadeService inviteRelationFacadeService;
    @Autowired
    private VipFacadeService vipFacadeService;
    @Autowired
    private ActivityFacadeService activityFacadeService;

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        int num = this.inviteRelationFacadeService.getSuccessInvitationInfo(userId);
        if (Objects.isNull(num) || num == 0) {
            this.remove(popUpWindows, PopUpEnum.TOBE_VIP_INVITE_SPEED);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        Long userId = popUpWindows.getParam().getUserId();
        TobeVipInviteSpeedDto tsd = this.vipFacadeService.inviteVipEntity(userId);
        tsd.setNum(this.inviteRelationFacadeService.getSuccessInvitationInfo(userId));
        tsd.setDifferNum(this.activityFacadeService.differInviteNum(userId));
        tsd.setIsVip(Boolean.valueOf(this.vipFacadeService.isVip(userId)));
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> p.setExt(JSONObject.toJSONString((Object)tsd)));
        }
        this.inviteRelationFacadeService.removeSuccessInvitation(userId);
    }
}

