/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.fossicker.base.service.impl.popup.process.vipPage;

import com.bxm.fossicker.base.bo.FilterPopUpWindowsBO;
import com.bxm.fossicker.base.enums.PopUpEnum;
import com.bxm.fossicker.base.enums.PopUpProcessOrderEn;
import com.bxm.fossicker.base.param.PopUpWindowsCloseParam;
import com.bxm.fossicker.base.service.impl.popup.annotation.PopUpProcess;
import com.bxm.fossicker.base.service.impl.popup.process.AbstractPopUpWindowsProcess;
import com.bxm.fossicker.user.facade.vip.VipFacadeService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@PopUpProcess(special=PopUpEnum.TOBE_VIP_NOTICE, order=PopUpProcessOrderEn.CUSTOM)
public class TobeVipPopWindowsProcess
extends AbstractPopUpWindowsProcess {
    private static final Logger log = LoggerFactory.getLogger(TobeVipPopWindowsProcess.class);
    @Autowired
    private VipFacadeService vipFacadeService;

    @Override
    protected boolean preInvoke(FilterPopUpWindowsBO popUpWindows) {
        if (StringUtils.compareVersion((String)popUpWindows.getParam().getCurVer(), (String)"1.6.0") >= 0) {
            this.remove(popUpWindows, PopUpEnum.TOBE_VIP_NOTICE);
            return false;
        }
        return true;
    }

    @Override
    protected void postInvoke(FilterPopUpWindowsBO popUpWindows) {
        Long userId = popUpWindows.getParam().getUserId();
        Integer num = this.vipFacadeService.pushTobeVipContent(userId);
        if (Objects.isNull(num) || num == 0) {
            this.remove(popUpWindows, PopUpEnum.TOBE_VIP_NOTICE);
        }
    }

    @Override
    protected void doClose(PopUpWindowsCloseParam param) {
    }

    @Override
    protected void afterCompletion(FilterPopUpWindowsBO popUpWindows) {
        List commonPopUpWindowsEntryList = (List)popUpWindows.getParam("CURRENT_PROCESS_SUPPORT_POP_UP_KEY");
        Long userId = popUpWindows.getParam().getUserId();
        if (!CollectionUtils.isEmpty((Collection)commonPopUpWindowsEntryList)) {
            commonPopUpWindowsEntryList.stream().forEach(p -> p.setExt(this.vipFacadeService.pushTobeVipContent(userId).toString()));
        }
        this.vipFacadeService.removeTobeVipPush(userId);
    }
}

