package com.bxm.fossicker.commodity.model.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "根据商品名查询商品列表结果DTO")
@Data
/**
 * 商品查询参数实体
 * @author Dong_hy
 */
public class CommoditySearchDTO {

    @ApiModelProperty(value = "商品id")
    private Long id;

    @ApiModelProperty(value = "淘宝商品id")
    private String goodsId;

    @ApiModelProperty(value = "商品标题")
    private String commodityTitle;

    @ApiModelProperty(value = "商品价格")
    private Double commodityPrice;

    @ApiModelProperty(value = "图片地址")
    private String imgUrl;

    @ApiModelProperty(value = "优惠券价格")
    private Double couponPrice;

    @ApiModelProperty(value = "商铺名称")
    private String shopName;

    @ApiModelProperty(value = "销量数")
    private Integer salesNumber;

    @ApiModelProperty(value = "佣金值")
    private Double commissionPrice;

    @ApiModelProperty(value = " 店铺类型，1-天猫，0-淘宝")
    private Integer shopType;



}
