package com.bxm.fossicker.commodity.model.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 商品查询参数实体
 * @author Dong_hy
 */
@ApiModel(description = "根据商品名查询商品列表")
@Data
public class CommoditySearchParam {

    @ApiModelProperty(value = "商品名称关键词", required = true)
    private String commodityName;

    @ApiModelProperty(value = "价格（券后价）上限")
    private Integer priceUpperLimit;

    @ApiModelProperty(value = "价格（券后价）下限")
    private Integer priceLowerLimit;

    @ApiModelProperty(value = "默认为0，0-综合排序，1-商品上架时间从高到低，2-销量从高到低，3-领券量从高到低，4-佣金比例从高到低，" +
            "5-价格（券后价）从高到低，6-价格（券后价）从低到高")
    private Integer sortType;


}
