package com.bxm.fossicker.enums;

import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;

/**
 * @ClassName WithDrawType
 * @CopyRright (c) 2019-bxm：杭州微财网络科技有限公司
 * @Author zhaoxin
 * @Date 2019/7/24 11:31
 * @Version 1.0.0
 **/
public enum WithdrawTypeEnum {
    /**
     * 1元提现
     */
    ONE(1),
    /**
     * 5元提现
     */
    FIVE(5),
    /**
     * 10元提现
     */
    TEN(10);

    private Integer amount;

    WithdrawTypeEnum(Integer amount) {
        this.amount = amount;
    }

    public static WithdrawTypeEnum valueOf(Integer type) {
        switch (type) {
            case 0:
                return WithdrawTypeEnum.ONE;
            case 1:
                return WithdrawTypeEnum.FIVE;
            case 2:
                return WithdrawTypeEnum.TEN;
            default:
                return WithdrawTypeEnum.ONE;
        }
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }
}
